<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminAuthController;
use App\Http\Controllers\Admin\AllUsersController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\DisebilityController;
use App\Http\Controllers\Admin\SpecialityController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\TermsAndConditionController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\VideoController;

use App\Http\Controllers\Mentor\MentorController;
use App\Http\Controllers\Mentor\MentorProfileController;
use App\Http\Controllers\Mentor\TutorialUploadeContoller;
use App\Http\Controllers\Mentor\PdfController;

use App\Http\Controllers\User\UserController;
use App\Http\Controllers\User\UserProfileController;
use App\Http\Controllers\User\UserVideoController;
use App\Http\Controllers\User\UserPdfController;
use App\Http\Controllers\ArticleGenerator;
use App\Http\Controllers\Web\HomeController; 

use App\Http\Controllers\Api\ForgotPasswordController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('view:clear');
});


Route::group(['namespace' => 'App\Http\Controllers\Admin'], function () {
    Route::get('admin/login', [AdminAuthController::class, 'index'])->name('login');
    Route::any('check/', [AdminAuthController::class, 'check'])->name('check');
    Route::get('logout', [AdminAuthController::class, 'logout'])->name("logout");
    // Route::get('/status-update/{id}',[AdminAuthController::class,'status_update'])->name("status_update");

    // // Change Password
    // Route::post('/change-password', [AdminAuthController::class, 'updatePassword'])->name('update-password');

});

Route::group(['namespace' => 'App\Http\Controllers\Api'], function () {

    Route::get('/reset-password', [ForgotPasswordController::class, 'resetPasswordLoad']);
    Route::post('/reset-password', [ForgotPasswordController::class, 'resetPassword']);

});

/* **************************************************** Admin Routes Start **************************************************** */
 
Route::group(['namespace' => 'App\Http\Controllers\Admin'], function() {

    Route::group(['prefix' => 'admin', 'middleware' => ['admin', 'auth']], function() { 

        //********************************** User crud start *********************************
        Route::get('dashboard', [AdminAuthController::class, 'adminHome'])->name('admin.home');
        Route::get('all-users', [AllUsersController::class, 'index'])->name('all.users');
        Route::get('create', [AllUsersController::class, 'create'])->name('create.users');
        Route::post('store', [AllUsersController::class, 'store'])->name('store.users'); 
        Route::get('status-update/{id}', [AllUsersController::class, 'statusUpdate'])->name('status.update'); 
        
        Route::get('edit/{users}', [AllUsersController::class, 'edit'])->name('edit');
        Route::put('update/{users}', [AllUsersController::class, 'update'])->name('update.users');
        Route::delete('delete/{id}', [AllUsersController::class, 'destroy'])->name('delete.users');

        Route::get('pending-users', [AllUsersController::class,'pending_status'])->name('pending.users');
        Route::get('approve-users', [AllUsersController::class,'approve_status'])->name('approve.users');
        Route::get('reject-users', [AllUsersController::class,'reject_status'])->name('reject.users');

        Route::get('teacher', [AllUsersController::class, 'getTeacher'])->name('teacher.index');

        Route::get('student', [AllUsersController::class, 'getStudent'])->name('student.index');
        
        //********************************** Users crud End *********************************
            
        //********************************** role crud start *********************************
        Route::get('role',[RoleController::class,'index'])->name('role.index');
        Route::get('role/create',[RoleController::class,'create'])->name('role.create');
        Route::post('role/store',[RoleController::class, 'store'])->name('role.store'); 
        Route::get('role-edit/{id}',[RoleController::class,'edit'])->name('role.edit');
        Route::put('role-update/{id}',[RoleController::class,'update'])->name('role.update');
        Route::delete('role/{id}',[RoleController::class,'destroy'])->name('role.destroy');  
        //********************************** role crud end ********************************* 

        //******************************* disebility crud start ************************************************
        Route::get('disebility',[DisebilityController::class,'index'])->name('disebility.index');
        Route::get('disebility/create',[DisebilityController::class,'create'])->name('disebility.create');
        Route::post('disebility/store',[DisebilityController::class, 'store'])->name('disebility.store'); 
        Route::get('disebility-edit/{id}',[DisebilityController::class,'edit'])->name('disebility.edit');
        // Route::put('disebility-update/{id}',[DisebilityController::class,'update'])->name('disebility.update');
        Route::post('disebility-update/{id}',[DisebilityController::class,'update'])->name('disebility.update');
        Route::delete('disebility-delete/{id}',[DisebilityController::class,'destroy'])->name('disebility.destroy');
        //******************************* disebility crud end ************************************************

        //********************************* speciality crud start ***********************************************       
        Route::get('speciality',[SpecialityController::class,'index'])->name('speciality.index');
        Route::get('speciality/create',[SpecialityController::class,'create'])->name('speciality.create');
        Route::post('speciality/store',[SpecialityController::class, 'store'])->name('speciality.store');   
        Route::get('speciality-edit/{id}',[SpecialityController::class,'edit'])->name('speciality.edit');
        Route::put('speciality-update/{id}',[SpecialityController::class,'update'])->name('speciality.update');
        Route::delete('speciality-delete/{id}',[SpecialityController::class,'destroy'])->name('speciality.destroy');       
        //******************************* speciality crud end ************************************************

        //********************************* FAQ crud start ***********************************************       
        Route::get('faq',[FaqController::class,'index'])->name('faq.index');
        Route::get('faq/create',[FaqController::class,'create'])->name('faq.create');
        Route::post('faq/store',[FaqController::class, 'faqStore'])->name('faq.store');
        Route::get('faq-edit/{id}',[FaqController::class,'edit'])->name('faq.edit');
        Route::put('faq-update/{id}',[FaqController::class,'update'])->name('faq.update');
        Route::delete('faq-delete/{id}',[FaqController::class,'destroy'])->name('faq.destroy');   
        //******************************* FAQ crud end ************************************************

        //**********************************Terms&Conditions crud Start ***********************************
        Route::get('terms', [TermsAndConditionController::class, 'index'])->name('terms.index');
        Route::get('terms/create', [TermsAndConditionController::class, 'create'])->name('terms.create');
        Route::post('terms/store', [TermsAndConditionController::class, 'store'])->name('terms.store');  
        Route::get('terms/edit/{terms}',[TermsAndConditionController::class,'edit'])->name('terms.edit');
        Route::put('terms/update/{terms}',[TermsAndConditionController::class,'update'])->name('terms.update');
        Route::delete('terms/delete/{id}',[TermsAndConditionController::class,'destroy'])->name('terms.destroy');  
        //**********************************Terms&Conditions crud End *************************************

        //**********************************Categories crud Start ***********************************
        Route::get('category', [CategoryController::class, 'index'])->name('category.index');
        Route::get('category/create', [CategoryController::class, 'create'])->name('category.create');
        Route::post('category/store', [CategoryController::class, 'store'])->name('category.store');  
        Route::get('category/edit/{id}',[CategoryController::class,'edit'])->name('category.edit');
        Route::post('category/update/{id}',[CategoryController::class,'update'])->name('category.update');
        Route::delete('category/delete/{id}',[CategoryController::class,'destroy'])->name('category.destroy');  
        //**********************************Categories crud End *************************************
        
        //**********************************New code for video and pdf *************************************
        Route::get('video', [VideoController::class, 'index'])->name('videoinsert.index');
        Route::post('videoStore', [VideoController::class, 'store'])->name('video.store');
        Route::get('all_video', [VideoController::class, 'video_list'])->name('video.list');
        Route::get('video-edit/{id}',[VideoController::class,'edit'])->name('video.edit');
         Route::delete('video-delete/{id}',[VideoController::class,'destroy'])->name('video.destroy');
          Route::get('updatevideo/{id}', [VideoController::class, 'statusUpdate'])->name('updatevideo'); 
           Route::put('videoupdate/{id}',[VideoController::class,'update'])->name('video.update');
           Route::get('download/{id}', [VideoController::class, 'download'])->name('video.download');
           //**********************************video and pdf crud End *************************************

    });

});

/* **************************************************** Admin Routes End **************************************************** */


/* **************************************************** Mentor Routes Start **************************************************** */

Route::group(['namespace' => 'App\Http\Controllers\Mentor'], function() {
    
    Route::group(['prefix' => 'mentor', 'middleware' => ['is_mentor', 'auth']], function() {
        Route::get('dashboard', [MentorController::class, 'index'])->name('mentor.home');
        Route::get('mentor-profile', [MentorController::class, 'profile'])->name('mentor.profile');

        // Change Password
        Route::get('password', [MentorController::class, 'changePassword'])->name('change-password');
        Route::post('/change-password', [MentorController::class, 'updatePassword'])->name('update-password');

        // mentor video uploding crud
        Route::get('all-tutorial', [TutorialUploadeContoller::class, 'index'])->name('tutorial.index');
        Route::get('add-tutorial', [TutorialUploadeContoller::class, 'create'])->name('tutorial.create');
        Route::post('store', [TutorialUploadeContoller::class, 'store'])->name('tutorial.store');
        Route::get('file-edit/{id}',[TutorialUploadeContoller::class,'edit'])->name('files.edit');
        Route::put('file-update/{id}',[TutorialUploadeContoller::class,'update'])->name('files.update');
        Route::delete('file-delete/{id}',[TutorialUploadeContoller::class,'destroy'])->name('files.destroy');
        Route::get('download/{id}', [TutorialUploadeContoller::class, 'download'])->name('files.download');
        Route::get('update/{id}', [TutorialUploadeContoller::class, 'statusUpdate'])->name('update'); 

        // mentor video uploding crud
        // Route::get('file-index', [VideoController::class, 'index'])->name('files.index');
        // Route::get('file-create', [VideoController::class, 'create'])->name('files.create');
        // Route::post('file-store', [VideoController::class, 'store'])->name('video.store');
        // Route::get('file-edit/{id}',[VideoController::class,'edit'])->name('files.edit');
        // Route::put('file-update/{id}',[VideoController::class,'update'])->name('files.update');
        // Route::delete('file-delete/{id}',[VideoController::class,'destroy'])->name('files.destroy');
        // Route::get('download/{id}', [VideoController::class, 'download'])->name('files.download');

        // mentor Pdf uploding crud
        Route::get('pdf-index', [PdfController::class, 'index'])->name('pdf.index');
        Route::get('pdf-create', [PdfController::class, 'create'])->name('pdf.create');
        Route::post('pdf-store', [PdfController::class, 'store'])->name('pdf.store');
        Route::get('pdf-edit/{id}',[PdfController::class,'edit'])->name('pdf.edit');
        Route::put('pdf-update/{id}',[PdfController::class,'update'])->name('pdf.update');
        Route::delete('pdf-delete/{id}',[PdfController::class,'destroy'])->name('pdf.destroy');
        Route::get('download/{id}', [PdfController::class, 'download'])->name('pdf.download');
        
        

    });

});

/* **************************************************** Mentor Routes End **************************************************** */


/* **************************************************** User Routes Start **************************************************** */

Route::group(['namespace' => 'App\Http\Controllers\User'], function() {
    
    Route::group(['prefix' => 'user', 'middleware' => ['is_user', 'auth']], function() {
        Route::get('dashboard', [UserController::class, 'index'])->name('user.home');

        Route::get('user-profile', [UserProfileController::class, 'index'])->name('user.index');   

        Route::get('video-index', [UserVideoController::class, 'index'])->name('video.index');
        Route::get('doc-index', [UserPdfController::class, 'index'])->name('doc.index');
    });

});

/* **************************************************** User Routes End **************************************************** */



/* **************************************************** Web Routes Start **************************************************** */
Route::get('/write', function () {
    $title = '';
    $content = '';
    return view('write', compact('title', 'content'));
});
Route::group(['namespace' => 'App\Http\Controllers\Web'], function () {
    Route::get('home', [HomeController::class, 'index'])->name('home');
    Route::get('mentor-register', [HomeController::class, 'mentorRegister'])->name('mentor_register');
    Route::post('mentor-store',[HomeController::class,'mentorStore'])->name('mentor.store');  

    Route::get('people-register', [HomeController::class, 'peopleRegister'])->name('people_register');
    Route::post('people-store',[HomeController::class,'peopleStore'])->name('people.store');
    Route::post('/write/generate', [ArticleGenerator::class, 'index']);
    
    Route::get('privacy-policy',[HomeController::class,'privacyPolicy']);
    
    
});

/* **************************************************** Web Routes End **************************************************** */
