<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\LoginWithOtpController;
use App\Http\Controllers\Api\ForgotPasswordController;
use App\Http\Controllers\Api\DisebilityController;
use App\Http\Controllers\Api\ContactUsController;
use App\Http\Controllers\Api\TeacherController;
use App\Http\Controllers\Api\TutorialUploadeContoller;
use App\Http\Controllers\Api\FaqController;
use App\Http\Controllers\Api\TermsAndConditionController;
use App\Http\Controllers\Api\CategoryController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => 'v1'], function() {

    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/register', [AuthController::class, 'register']);
    // Route::post('/change-password', [AuthController::class, 'changePassword']);
    Route::post('/register-otp-generate', [AuthController::class, 'otpGenerate']);
    Route::post('/otp-varification', [AuthController::class, 'loginWithOtp']);
    Route::post('/resend-otp', [AuthController::class, 'resendOtp']);

    Route::post('/login-otp-generate', [LoginWithOtpController::class, 'loginOtpGenerate']); 
    Route::post('/otp-login', [LoginWithOtpController::class, 'loginWithOtp']);
    Route::post('/resend-login-otp', [LoginWithOtpController::class, 'resendLoginOtp']);

    Route::post('/forget-password', [ForgotPasswordController::class, 'forgetPassword']);

});


Route::group(['prefix' => 'v1', 'middleware' => ['auth:api']], function() {
// Route::group(['prefix' => 'v1'], function() {

    Route::get('/show-detail/{id}', [AuthController::class, 'ShowDetail']);
    Route::post('/user-update/{id}', [AuthController::class, 'update']);
    Route::get('/get-user', [AuthController::class, 'userInfo']);
    Route::get('/all-student', [AuthController::class, 'getAllStudent']);
    Route::post('/update-password', [AuthController::class, 'updatePassword']);

    // contact us
    Route::post('/contact-us', [ContactUsController::class, 'contactUs']);

    // teacher Controllers
    Route::get('/student-count', [TeacherController::class, 'studentCount']);

    // add tutorial
    Route::post('/add-tutorial', [TutorialUploadeContoller::class, 'addTutorial']);
    Route::get('/active-tutorial', [TutorialUploadeContoller::class, 'activeTutorial']);
    Route::get('/disable-tutorial', [TutorialUploadeContoller::class, 'disableTutorial']);
    Route::get('/all-tutorial', [TutorialUploadeContoller::class, 'allTutorial']);
    Route::get('/show-tutorial', [TutorialUploadeContoller::class, 'showTutorial']);

    // Faq API
    Route::get('/faq', [FaqController::class, 'getFaq']); 

    // Faq API
    Route::get('/terms-and-condition', [TermsAndConditionController::class, 'getTerms']);

    // Disabilty Get api
    Route::get('/disebility', [DisebilityController::class, 'getDisebility']);

    // Category Get api
    Route::get('/category', [CategoryController::class, 'getCategory']);


});

// Route::group(['prefix' => 'v1', 'middleware' => ['auth:api']], function() {
//     Route::get('/get-user', [AuthController::class, 'userInfo']);  
// });

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
