@extends('web.layouts.app')
@section('content')
  
<section class="contact_reg sec_padding">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 col-md-6 p-3">
                <div class="contact_form-people">
                    <div class="sec_title mb-4">
                         @if(session()->has('message'))
                        <div class="alert alert-success">
                            {{ session()->get('message') }}
                        </div>
                        @endif
                        <h3>People Registration</h3>
                    </div> 
                    <form method="POST" action="{{ route('people.store') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="row g-3 mentor-login">
                            <div class="col-lg-6 col-md-6">
                                <input type="text" name="name" id="name" class="form-control" placeholder="Full Name" required>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <input type="text" name="email" id="email" class="form-control" placeholder="Email Id"  required>
                            </div>
                            <div class="col-lg-12 col-md-12 mt-4">
                                <input type="text" name="address" id="address" class="form-control" placeholder="Address">
                            </div>
                            <div class="col-lg-12 col-md-12">
                                <select name="disability_category" id="disability_category" class="d-block w-100 form-control">
                                    <option>Enter Disability</option>  
                                    @foreach($disebilities as $dis)
                                    <option value="{{ $dis->disebility }}">{{ $dis->disebility }}</option>
                                    @endforeach
                                    
                                    <!-- <option value="Mental">Mental</option>
                                    <option value="illness">illness</option>
                                    <option value="Physical">Physical</option>
                                    <option value="Sensory">Sensory</option> -->
                                </select>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <input type="text" name="location" id="location" class="form-control" placeholder="Location">
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <input type="time" name="time" id="time" class="form-control" placeholder="Time">
                            </div> 
                            <div class="col-lg-12 col-md-12">
                                <textarea name="special_condition" id="special_condition" cols="30" rows="4" class="form-control"
                                    placeholder="Special Condition"></textarea>
                            </div> 
                            <div class="col-lg-12 col-md-12 ">
                                <button class="btn btn_theme mb-3" type="submit" value="">SUBMIT</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="people-img">
                    <img src="{{ asset('assets/admin_assets/images/home/mentor-registration.png') }}" class="w-auto ms-auto" alt="img..">
                </div>
            </div>
        </div>
    </div>
</section> 

@endsection