@extends('admin.layouts.app')
@section('content')

<div class="nk-wrap ">
<div class="nk-header nk-header-fixed is-light"></div>
<div class="nk-content ">
   <div class="container-fluid">
      <div class="nk-content-inner">
         <div class="nk-content-body">
            <div class="form-group">
               <div class="card card-preview">
                  <div class="card-inner">
                      <div class="preview-block"> <span class="preview-title-lg overline-title">Default Preview</span> </div>
                    
                     <div class="nk-block nk-block-lg">
                        <div class="nk-block-head">
                           <div class="nk-block-head-content nk-block-head-content d-flex justify-content-between align-items-center">
                              <h4 class="nk-block-title">All Videos</h4>
                         
                           </div>
                        </div>
                        <div class="card card-preview">
                           <div class="card-inner">
                              <table class="datatable-init nowrap table">
                                 <thead>
                                    <tr>
                                       <th>Id</th>
                                       <th>Heading</th>
                                       <th>Discription</th>
                                       <th>Video</th>
                                       <!--<th>Open Video</th>-->
                                       <th>Status</th>
                                       <th>Action</th>
                                    </tr>
                                 </thead>
                                 <tbody>
                                    <tr>
                                    
                                       @foreach ($video_list as $video_lists) 
                                   
                                       <td>{{$video_lists->id}}</td>
                                       <td>{{$video_lists->heading}}</td>
                                       <td>{{$video_lists->content}}</td>
                                     
                                       <td>
                                          <video controls>
                                                <source class="videosrc" src="{{ asset("video_file/$video_lists->video_file") }}" type="video/mp4" width="100px" height="80px">
                                            </video>
                                       </td>
                                      
                                       <td>
                                           <?php if($video_lists->status == 1){ ?>  
                                                <a href="{{url('admin/updatevideo',$video_lists->id)}}" class="btn btn-primary">Active</a>
                                          <?php } else {?>
                                                <a href="{{url('admin/updatevideo',$video_lists->id)}}" class="btn btn-danger">Disable</a>
                                          <?php } ?>
                                       </td>
                                       <td>
                                        <a href="{{route('video.edit',$video_lists->id)}}" class="btn btn-primary btn-sm">Edit</a>
                                          <!--<a href="/download/{{$video_lists->video_file}}"download="{{$video_lists->video_file}}" class="btn btn-primary btn-sm">Download</a>-->
                                          <a  onclick="deleteFile({{ $video_lists->id }})" class="btn btn-danger btn-sm">Delete</a>
                                          <form id="file-edit-action-{{ $video_lists->id }}" action="{{ route('video.destroy',$video_lists->id) }}" method="post">
                                             @csrf
                                             @method('DELETE')
                                          </form>
                                       </td>
                                    </tr> 
                                    @endforeach
                                 </tbody>
                              </table>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
 </div>
</div>
<script>
   function deleteFile(id) {
       if (confirm("Are you sure you want to Delete ?")) {
           document.getElementById('file-edit-action-'+id).submit();
       }
   }
</script>
@endsection

