@extends('admin.layouts.app')
@section('content')

<div class="nk-wrap "> 
    <div class="nk-header nk-header-fixed is-light"></div> 
    <div class="nk-content ">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="form-group">
                        <div class="card card-preview">
                            <div class="card-inner">
                                <!-- <div class="preview-block">
                                    <span class="preview-title-lg overline-title">Default Preview</span>
                                </div> -->
                                <div class="nk-block nk-block-lg">
                                    <div class="nk-block-head">
                                        <div class="nk-block-head-content nk-block-head-content d-flex justify-content-between align-items-center">
                                            <h4 class="nk-block-title">Trashed Disebility</h4> 
                                            <a href="{{route('disebility.index')}}" class="btn btn-primary">Back</a>
                                        </div>
                                    </div>
                                    @if(Session::has('success'))
                                    <div class="alert alert-success"> 
                                        {{Session::get('success')}}         
                                    </div>
                                    @endif
                                    <div class="card card-preview">
                                        <div class="card-inner">
                                            <table class="datatable-init nowrap table">
                                                <thead>
                                                    <tr>
                                                        <th>ID</th>
                                                        <th>Disebilities</th>     
                                                        <th>Action</th>                                                 
                                                    </tr>
                                                </thead>
                                                <tbody>                                                                                                                                                    
                                                    @foreach ($disebilities as $disebility)
                                                    <tr>                         
                                                        <td>{{ $disebility->id }}</td>
                                                        <td>{{ $disebility->disebility }}</td>  
                                                        <td>
                                                        <a href="{{route('disebility.restore',$disebility->id)}}" class="btn btn-dark btn-sm">Restore</a>
                                                        <a href="#" onclick="deleteDisebility({{ $disebility->id }})" class="btn btn-danger btn-sm">Delete Forever</a>
    
                                                        </td>                                                    
                                                    </tr> 
                                                    @endforeach                                                                                                                                                 
                                                </tbody>
                                            </table>
                                        </div>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
   function deleteDisebility(id) {
       if (confirm("Are you sure you want to delete?")) {
          window.location.href='{{url("/delete-disebility-parmanently") }}/'+id;
       }
   }
</script>

    @endsection