@extends('admin.layouts.app')
@section('content')

<div class="nk-wrap ">
    <!-- main header @s -->
    <div class="nk-header nk-header-fixed is-light"></div>
    <!-- content @s -->
    <div class="nk-content ">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body"> 
                    @if(session()->has('message'))
                        <div class="alert alert-success">
                        {{ session()->get('message') }}
                        </div>
                    @endif
                    <div class="nk-block-head nk-block-head-sm">
                        <div class="nk-block-between">
                            <div class="nk-block-head-content"> 
                                <h3 class="nk-block-title page-title">Edit User</h3>
                            </div>
                        </div><!-- .nk-block-between -->
                    </div><!-- .nk-block-head -->
                    <div class="form-group">
                        <div class="card card-preview">
                            <div class="card-inner">
                                <div class="preview-block">
                                    <form method="POST" action="{{ route('update.users', $users->id) }}" enctype="multipart/form-data">
                                        @csrf
                                        @method('put')
                                        <!-- <span class="preview-title-lg overline-title">Default Preview</span> -->
                                        <div class="row gy-4">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="default-01">Name <span class="text-danger">*</span></label>
                                                    <div class="form-control-wrap">
                                                        <input type="text" class="form-control" id="name" name="name" placeholder="Name" value="{{old('name', $users->name)}}">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="default-01">Email <span class="text-danger">*</span></label>
                                                    <div class="form-control-wrap">
                                                        <input type="text" class="form-control" id="email" name="email" placeholder="Email" value="{{old('email', $users->email)}}">
                                                    </div>
                                                </div>
                                            </div>

                                           {{------- <!-- <div class="row gy-4">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="default-01">Url <span class="text-danger">*</span></label>
                                                    <div class="form-control-wrap">
                                                        <input type="text" class="form-control"  name="url" placeholder="Url" value="{{ $edit->url)}}">
                                                    </div>
                                                </div>
                                            </div> -->-----}}

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="default-06">Select Role<span class="text-danger">*</span></label>
                                                    <div class="form-control-wrap ">
                                                        <div class="form-control-select">
                                                            <select name="role" id="role" class="d-block w-100 form-control">
                                                                <option>Select Role</option>
                                                                @foreach($roles as $role)
                                                                    <option value="{{ $role->id }}">{{ $role->name }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="default-textarea">Address<span class="text-danger">*</span></label>
                                                    <div class="form-control-wrap">
                                                        <input type="text" class="form-control" id="address" name="address" placeholder="Address" value="{{old('address', $users->UserDetail->address ?? '')}}">
                                                    </div>
                                                </div>
                                            </div> 
                                        </div>
                                        <small class="mt-4 mb-4 d-block overline-title">Support required</small>
                                        <div class="row gy-4">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="default-1-02">Time <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" id="time" name="time" placeholder="Totimecation" value="{{ old('time',$users->UserDetail->time ?? '')}}">
                                                </div>
                                            </div> 
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="default-1-02">Location <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" id="location" name="location" placeholder="Location" value="{{ old('location',$users->UserDetail->location ?? '')}}">
                                                </div>
                                            </div> 
                                        </div> 
                                        <div class="row gy-4"> 
                                            <div class="col-md-12 text-right">
                                                <button type="submit" value="" class="btn btn-primary">Submit</button>
                                            </div> 
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection