@extends('admin.layouts.app')
@section('content')
<div class="nk-wrap "> 
    <div class="nk-header nk-header-fixed is-light"></div> 
        <div class="nk-content ">
            <div class="container-fluid">
                <div class="nk-content-inner">
                    <div class="nk-content-body">
                        @if(session()->has('message'))
                        <div class="alert alert-success">
                            {{ session()->get('message') }}
                        </div>
                        @endif
                    <div class="nk-block-head nk-block-head-sm">
                        <div class="nk-block-between">
                            <div class="nk-block-head-content">
                                <h3 class="nk-block-title page-title">Edit Files</h3>
                            </div>
                        </div> 
                    </div> 
                    <div class="form-group">
                        <div class="card card-preview">
                            <div class="card-inner">
                                <div class="preview-block">
                                    <form method="post" action="{{route('files.update',$mentors->id)}}" enctype="multipart/form-data">
                                        @csrf
                                        @method('PUT')
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label class="form-label" for="default-01">Content <span class="text-danger"></span></label>
                                                <div class="form-control-wrap">
                                                <input type="text" class="form-control @error('content') is-invalid @enderror" id="content" name="content" placeholder="Content"  value="{{old('content', $mentors->content)}}">
                                                @error('content')
                                                <p class="invalid-feedback">{{$message}}</p>
                                                @enderror 
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label class="form-label" for="default-01">Heading <span class="text-danger"></span></label>
                                                <div class="form-control-wrap">
                                                <input type="text" class="form-control @error('heading') is-invalid @enderror" id="heading" name="heading" placeholder="heading" value="{{old('heading', $mentors->heading)}}">
                                                @error('heading')
                                                <p class="invalid-feedback">{{$message}}</p>
                                                @enderror 
                                                </div>
                                            </div>
                                        </div>
                                        <br>                       
                                        <div class="col-sm-6">
                                            <label for="default-01">Video File<span class="text-danger"></span></label>
                                            <div class="form-control-wrap">
                                            <input type="file" class="form-control @error('video_file') is-invalid @enderror" id="video_file" name="video_file"  value="{{old('video_file', $mentors->video_file)}}">                                             
                                                <iframe src="{{'/video_file'.$mentors->video_file}}" width="70px" height="70px" ></iframe>
                                                @error('video_file')
                                                <p class="invalid-feedback">{{$message}}</p>
                                                @enderror 
                                            </div>
                                        </div>
                                        <br>
                                        <button type="submit">Submit</button>   
                                    </form>
                                </div>
                            </div>
                        </div> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection