@extends('admin.layouts.app')
@section('content')
<div class="nk-wrap "> 
    <div class="nk-header nk-header-fixed is-light"></div> 
        <div class="nk-content ">
            <div class="container-fluid">
                <div class="nk-content-inner">
                    <div class="nk-content-body">
                        @if(session()->has('message'))
                        <div class="alert alert-success">
                            {{ session()->get('message') }}
                        </div>
                        @endif
                    <div class="nk-block-head nk-block-head-sm">
                        <div class="nk-block-between">
                            <div class="nk-block-head-content">
                                <h3 class="nk-block-title page-title">Add Video</h3>
                                <a href="{{route('tutorial.index')}}" class="btn btn-primary">View List</a>
                            </div>
                        </div>  
                    </div> 
                    <div class="form-group">
                        <div class="card card-preview">
                            <div class="card-inner">
                                <div class="preview-block"> 
                                    <form method="post" action="{{ route('tutorial.store') }}" enctype="multipart/form-data">
                                        @csrf   
                                        <div class="row gy-4">
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label class="form-label" for="default-01">Heading <span class="text-danger">*</span></label>
                                                    <div class="form-control-wrap">
                                                        <input type="text" class="form-control @error('heading') is-invalid @enderror" id="heading" name="heading" placeholder="Heading" value="{{old('heading')}}">
                                                        @error('heading')
                                                            <p class="invalid-feedback">{{$message}}</p>
                                                        @enderror 
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row gy-4"> 
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label class="form-label" for="default-01">Discription <span class="text-danger">*</span></label>
                                                    <div class="form-control-wrap">
                                                        <textarea type="text" class="form-control @error('content') is-invalid @enderror" id="content" name="content" placeholder="Content" value="{{old('content')}}"></textarea>
                                                        @error('content')
                                                            <p class="invalid-feedback">{{$message}}</p>
                                                        @enderror 
                                                    </div>
                                                </div>
                                            </div> 
                                        </div>
                                        <div class="row gy-4"> 
                                            <div class="col-sm-12">
                                            <label class="form-label" for="default-01">Video File <span class="text-danger">*</span></label>
                                                <div class="form-control-wrap">
                                                    <input type="file" class="form-control @error('video_file') is-invalid @enderror" id="video_file" name="video_file"  value="{{old('video_file')}}">
                                                    @error('video_file')
                                                    <p class="invalid-feedback">{{$message}}</p>
                                                    @enderror 
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row gy-4"> 
                                            <div class="col-sm-12">
                                            <label class="form-label" for="default-01">PDF File <span class="text-danger">*</span></label>
                                                <div class="form-control-wrap">
                                                    <input type="file" class="form-control @error('pdf_file') is-invalid @enderror" id="pdf_file" name="pdf_file"  value="{{old('pdf_file')}}">
                                                    @error('video_file')
                                                    <p class="invalid-feedback">{{$message}}</p>
                                                    @enderror 
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row gy-4">  
                                            <div class="col-md-12 text-right">
                                                <button type="submit" value="" class="btn btn-primary">Submit</button>
                                            </div> 
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection