@extends('admin.layouts.app')
@section('content')
<div class="nk-wrap "> 
    <div class="nk-header nk-header-fixed is-light"></div> 
        <div class="nk-content ">
            <div class="container-fluid">
                <div class="nk-content-inner">
                    <div class="nk-content-body">
                        @if (session('status'))
                            <div class="alert alert-success" role="alert">
                                {{ session('status') }}
                            </div>
                        @elseif (session('error'))
                            <div class="alert alert-danger" role="alert">
                                {{ session('error') }}
                            </div>
                        @endif
                    <div class="nk-block-head nk-block-head-sm">
                        <div class="nk-block-between">
                            <div class="nk-block-head-content">
                                <h3 class="nk-block-title page-title">Change Password</h3> 
                            </div>
                        </div>  
                    </div> 
                    <div class="form-group">
                        <div class="card card-preview">
                            <div class="card-inner">
                                <div class="preview-block"> 
                                    <form method="post" action="{{ route('update-password') }}" enctype="multipart/form-data">
                                        @csrf   
                                        <div class="row gy-4">
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label class="form-label" for="default-01">Old Password <span class="text-danger">*</span></label>
                                                    <div class="form-control-wrap">
                                                        <input type="password" class="form-control @error('old_password') is-invalid @enderror" id="old_password" name="old_password" placeholder="Old Password" value="{{old('old_password')}}">
                                                        @error('old_password')
                                                            <p class="invalid-feedback">{{$message}}</p>
                                                        @enderror 
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row gy-4"> 
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label class="form-label" for="default-01">New Password <span class="text-danger">*</span></label>
                                                    <div class="form-control-wrap">
                                                        <input type="password" class="form-control @error('new_password') is-invalid @enderror" id="new_password" name="new_password" placeholder="New Password" value="{{old('new_password')}}">
                                                        @error('new_password')
                                                            <p class="invalid-feedback">{{$message}}</p>
                                                        @enderror 
                                                    </div>
                                                </div>
                                            </div> 
                                        </div>
                                        <div class="row gy-4"> 
                                            <div class="col-sm-12">
                                            <label class="form-label" for="default-01">Confirm New Password <span class="text-danger">*</span></label>
                                                <div class="form-control-wrap">
                                                    <input type="password" class="form-control @error('new_password_confirmation') is-invalid @enderror" id="new_password_confirmation" name="new_password_confirmation" placeholder="Confirm New Password" value="{{old('new_password_confirmation')}}">
                                                    @error('new_password_confirmation')
                                                    <p class="invalid-feedback">{{$message}}</p>
                                                    @enderror 
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row gy-4">  
                                            <div class="col-md-12 text-right">
                                                <button type="submit" value="" class="btn btn-primary">Submit</button>
                                            </div> 
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection