@extends('admin.layouts.app')
@section('content')

<div class="nk-wrap "> 
    <div class="nk-header nk-header-fixed is-light"></div> 
    <div class="nk-content ">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="form-group">
                        <div class="card card-preview">
                            <div class="card-inner">
                                <!-- <div class="preview-block">
                                    <span class="preview-title-lg overline-title">Default Preview</span>
                                </div> -->
                                <div class="nk-block nk-block-lg">
                                    <div class="nk-block-head">
                                        <div class="nk-block-head-content nk-block-head-content d-flex justify-content-between align-items-center">
                                            <h4 class="nk-block-title">All Roles</h4> 
                                            <a href="{{ route('role.create') }}" class="btn btn-primary">Add Role</a>
                                        </div>
                                    </div>
                                    <div class="card card-preview">
                                        <div class="card-inner">
                                            <table class="datatable-init nowrap table">
                                                <thead>
                                                    <tr>
                                                        <th>ID</th>
                                                        <th>Role ID</th>
                                                        <th>Name</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>  
                                                    <?php $i = 0; ?>
                                                    @foreach ($roles as $role)
                                                    <tr>   
                                                        <?php $i++; ?>
                                                        <td>{{ $i }}</td>
                                                        <td>{{$role->id}}</td>
                                                        <td>{{$role->name}}</td> 
                                                        <td>
                                                        <a href="{{ route('role.edit',$role->id) }}" class="btn btn-primary btn-sm">Edit</a>

                                                        <a onclick="deleteRole({{$role->id}})" class="btn btn-danger btn-sm">Delete</a>
                                                        <form id="role-edit-action-{{ $role->id }}" action="{{route('role.destroy',$role->id)}}" method="post">
                                                            @csrf
                                                            @method('delete')
                                                            </form>
                                                        </td>
                                                    </tr> 
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
    function deleteRole(id){
        if(confirm("Are You Sure You Want To Delete?")){
            document.getElementById('role-edit-action-'+id).submit();
        }}
</script>

    @endsection