<?php

namespace App\Services\Api;
use Illuminate\Http\Request; 

use Illuminate\Support\Str;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon; 
use App\Mail\NewUserCreateMail;
use App\Models\UserDetail; 
use App\Models\PasswordReset;
use App\Models\UserOtp;
use App\Models\User;
use Auth;
use Hash;   
use DB;

class UserService {
  
    public function __construct( 
        User $user
    ) {     
        $this->user= $user;
    }

    // user registation
    public function register(Request $request) {  
        
        $existingUser = User::where('email', $request->email)->first();
        if ($existingUser) {
            return response()->json([
                'success' => false,
                'message' => 'Email already registered'
            ]);
        }

        // store a data user table   
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->gender = $request->gender;
        $user->role = $request->role;
        $user->cleanpass = $request->password;
        //$user->role = 2;
        // dd($request->password);
        // $user->password = Hash::make($user['password']);
        $user->password = Hash::make($request->password); 
        $user->save(); 

        // store a data UserDetail table
        $address = new UserDetail();
        $address->user_id = $user->id;
        $address->disability_category = $request->disability_category;
        $address->speciality_category = $request->speciality_category;
        $address->teacher = $request->teacher;
        $address->time = $request->time;
        $address->location = $request->location; 
        $address->address = $request->address;
        $address->special_condition = $request->special_condition;
        $address->save(); 
        $token = $user->createToken('Token')->accessToken;

        return response()->json([
            'succes' => true, 
            'message' => 'user registered successfully!.',
            'data' => [  
                'user_id' => $user->id,
                'user_name' => $user->name,
                'email' => $user->email,
                'token'=>$token,
                'category' => $address->disability_category
            ]
        ], 200); 

    }

    // user login
    public function login(Request $request) {  
        $input = $request->all();
       // dd($input);
        // $this->validate($request, [
        //     'email' => 'unique:users,email',
        //     'password' => 'required',
        // ]);

        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        if(auth()->attempt(array('email' => $input['email'], 'password' => $input['password']))) {
            if (auth()->user()->role == 8 && auth()->user()->status == 1) {
                $token = auth()->user()->createToken('token')->accessToken;
                // $user = auth()->user();
                
                $user = User::with('userDetail')->where('email', $request->email)->first();
                $userData = $user->toArray();
                $userDetail = $user->userDetail->toArray();

                return response()->json([
                    'succes' => 'true', 
                    'message' => 'admin login successfully',
                    'data' => $user,
                    'token' => $token,
                ], 201);
            } else if (auth()->user()->role == 1 && auth()->user()->status == 1) {
                $token = auth()->user()->createToken('token')->accessToken;
                // $user = auth()->user();

                $user = User::with('userDetail')->where('email', $request->email)->first();
                $userData = $user->toArray();
                $userDetail = $user->userDetail->toArray();

                return response()->json([
                    'succes' => 'true', 
                    'message' => 'teacher login successfully',
                    'data' => $user,
                    'token' => $token
                ], 201);
            } else if (auth()->user()->role == 2 && auth()->user()->status == 1) { 
                $token = auth()->user()->createToken('token')->accessToken;
                // $user = auth()->user();
                
                $user = User::with('userDetail')->where('email', $request->email)->first();
                $userData = $user->toArray();
                $userDetail = $user->userDetail->toArray();
                
                return response()->json([
                    'succes' => 'true',  
                    'message' => 'student login successfully',
                    'data' => $user,
                    'token' => $token
                ], 201); 
            } else { 
                return response()->json([
                    'succes' => "false",  
                    'message' => 'Please wait while we are processing your request...'
                ], 201); 
            }
        } else {
            return response()->json([
                'succes' => 'false',  
                'message' => 'Email-Address And Password Are Wrong.'
            ], 401);
        }

        if(auth()->attempt($input)){
            $token = auth()->user()->createToken('token')->accessToken;
            return response()->json([
                'succes' => 'true',
                'token' => $token,
                'message' => 'User login successfully',
            ], 201);
        } 

    }

    // user info
    public function userInfo(){
        $user = auth()->user();
        // dd($user);
        return response()->json([
            'succes' => 'true',
            'message' => 'login user details', 
            'data' => [  
                'id' => $user->id,
                'name' => $user->name,
                'email' => $user->email,
                'mobile_number' => $user->mobile_number,
                'Disability Category' => $user->userDetail->disability_category,
                'Speciality Category' => $user->userDetail->speciality_category,
                'teacher' => $user->userDetail->teacher,
                'time' => $user->userDetail->time,
                'location' => $user->userDetail->location,
                'address' => $user->userDetail->address,
                'special_condition' => $user->userDetail->special_condition,
                // 'mobile_number' => $user->mobile_number
            ]
        ], 200);
    }

    // User otp generate 
    public function otpGenerate(Request $request) { 
        $request->validate([
            'mobile_number' => 'required|string|min:10|max:10',
        ]); 

        $now = now();  
        $user = UserOtp::create([
            'mobile_number' => $request->mobile_number, 
            'otp_code' => rand(1234, 9999),
            'expire_at' => $now->addMinutes(1),
        ]);  
 
        return response()->json([
            'success' => true, 
            'message' => 'OTP sent to your mobile number', 
            'data' => [  
                'otp_code' => $user->otp_code,
                'mobile_number' => $user->mobile_number
            ]
        ], 200);
    }

    // user otp varification
    public function loginWithOtp(Request $request) {
        $request->validate([
            'mobile_number' => 'required|string|min:10|max:10',
            'otp_code' => 'required|string|min:4|max:4',
        ]);
 
        $userOtp = UserOtp::where('mobile_number', $request->mobile_number)->where('otp_code',$request->otp_code)->first(); 

        $now = now();    

        if(!$userOtp){
            return response()->json([
                'error' => false, 
                'message' => 'Your OTP does not match!.'
            ], 200);
        } else if($userOtp && $now->isAfter($userOtp->expire_at)) {
            return response()->json([
                'error' => false, 
                'message' =>'Your OTP has been Expired!.'
            ], 200);
        }

        return response()->json([
            'succes' => true,
            'message' => 'OTP code verified successfully.!', 
        ]);
    }

    // user resend otp generate 
    public function resendOtp(Request $request) { 

        $request->validate([
            'mobile_number' => 'required|string|min:10|max:10',
        ]);

        $now = now(); 
        $user = UserOtp::create([
            'mobile_number' => $request->mobile_number, 
            'otp_code' => rand(1234, 9999),
            'expire_at' => $now->addMinutes(5),
        ]);  
  
        return response()->json([
            'success' => true, 
            'message' => 'OTP resend to your mobile number!.', 
            'data' => [  
                'otp_code' => $user->otp_code,
                'mobile_number' => $user->mobile_number
            ]
        ], 200);
    }

    public function updatePassword(Request $request, $id){
        $user = Auth::user();
        
        $validatedData = $request->validate([
            'old_password' => 'required',
            'new_password' => 'required|min:6|confirmed',
        ]);
        
        // Check if the current password matches the user's actual password
        if (!Hash::check($request->old_password, $user->password)) {
            return response()->json(['message' => 'Current password is incorrect'], 400);
        }

        // Update the user's password
        $user->password = Hash::make($request->new_password);
        $user->save();

        return response()->json(['message' => 'Password changed successfully']);
    }

    // Update User Details
    public function update(Request $request, $id){
        $data = $request->all();
        $users = User::find($id);
        $users->UserDetail()->delete();
        
        $users->UserDetail()->update([
            'user_id' => $users->id,
            'time' => $request->time,
            'location' => $request->location,
            'address' => $request->address,  
        ]);
        
        return response()->json([
            'message' => 'This User Updated Successfully !', 
        ], 200);
    }

    public function getAllStudent(){
        $allMentor = User::where('role', 2)->count();
        return response()->json([
            'succes' => 'true',
            'message' => 'Get All Student',
            'data' => $allMentor,
        ], 201);
    }
    
}