<?php

namespace App\Services\Api;
use Illuminate\Http\Request;
use App\Models\TutorialUpload;
use Illuminate\Support\Facades\Storage;
use URL;
use Auth;

class tutorialuploadeservice {
   
    //  Add Tutorial
    public function addTutorial(Request $request){
        // echo('hello'); die;
        $mentors = new TutorialUpload();
        $mentors->id = $request->id;
        $mentors->user_id = Auth::user()->id;
        $mentors->heading = $request->heading;
        $mentors->content = $request->content;

        if($request->video_file){
            $ext = $request->video_file->getClientOriginalExtension();
            $newfilename = time().'.'.$ext;
            $request->video_file->move(public_path().'/video_file',$newfilename);
            $mentors->video_file = $newfilename;
        }  

        if($request->pdf_file){
            $ext = $request->pdf_file->getClientOriginalExtension();
            $newfilenames = time().'.'.$ext;
            $request->pdf_file->move(public_path().'/pdf_file',$newfilenames);
            $mentors->pdf_file = $newfilenames;
        }

        $data= $mentors->save();

        return response()->json([
            'succes' => "true",
            'message' => 'File has been uploaded.',
        ], 201);
         
    } 

    //  Get All Student Tutorial
    public function studentCount(){
        $studentCount = User::where('role', 2)->count();
        return response()->json([
            'succes' => 'true',
            'message' => 'get all student',
            'total student' => $studentCount,
        ], 201);
    }

    //  Show Student Tutorial
    public function showTutorial(){   
        $user = auth()->user();
       // $showAllTutorial = TutorialUpload::get();
         $showAllTutorial = TutorialUpload::whereRaw("FIND_IN_SET($user->id,assign_teac_id)")->where('status', 1)->get();
        $showAllTutorial->each(function ($video) {
            $video->video_path = url(asset("video_file/$video->video_file"));
            $video->pdf_path = url(asset("pdf_file/$video->pdf_file"));
        });
      // $user = auth()->user();
        return response()->json([
            'succes' => 'true',
            'message' => 'show all tutorial',
            'data' => [  
                'student' => $showAllTutorial
            ]
        ], 201);
    }

    //  All Active Tutorial
    public function activeTutorial(){  
        $user = auth()->user();
        $activeTutorial = TutorialUpload::whereRaw("FIND_IN_SET($user->id,assign_teac_id)")->where('status', 1)->count();
        return response()->json([
            'succes' => 'true', 
            'message' => 'get all active tutorial', 
            'active tutorial' => $activeTutorial,  
        ], 201);
    }

    //  All Disable Tutorial
    public function disableTutorial(){     
       // $disableTutorial = TutorialUpload::where('status', 0)->count();
        $user = auth()->user();
        $disableTutorial = TutorialUpload::whereRaw("FIND_IN_SET($user->id,assign_teac_id)")->where('status', 0)->count();
       
        return response()->json([
            'succes' => 'true', 
            'message' => 'get all disable tutorial', 
            'disable tutorial' => $disableTutorial,  
        ], 201);
    }

    //  All Tutorial
    public function allTutorial(){     
        // $allTutorial = TutorialUpload::all()->count();
        $user = auth()->user();
        $disableTutorial = TutorialUpload::whereRaw("FIND_IN_SET($user->id,assign_teac_id)")->all()->count();
        return response()->json([
            'succes' => 'true', 
            'message' => 'get all tutorial', 
            'all tutorial' => $allTutorial,  
        ], 201);
    }
   
}