<?php

namespace App\Services\Admin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Route;  
use App\Models\Category; 

class CategoryService {

    public function __construct( 
        Category $category
    ) {    
        $this->category= $category;
    }

    // Disebility Store
    public function categoryStore(Request $request){
        $categories = new Category();
        $categories->name = $request->name;

        if($request->image){
            $ext = $request->image->getClientOriginalExtension();
            $newfilename = time().'.'.$ext;
            $request->image->move(public_path().'/image',$newfilename);
            $categories->image = $newfilename; 
        }

        $categories->save();

        if($categories->save()){
            return $categories;
        }

    }

    // Disebility Delete
    public function deleteCategoryById($id){
        $result = $this->category->where('id', $id)->delete();
        return $result;
    }
   
}
