<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Message;

class NewUserCreateMail extends Mailable {

    use Queueable, SerializesModels; 

    public function __construct($user) {
        $this->user = $user;
    }
 
    public function envelope() {
        return new Envelope(
            subject: 'ContactMail',
        );
    }
 
    public function content() {
        return new Content(
            view: 'email',
        );
    }
 
    public function attachments() {
        return [];
    }

    public function build(){
        return $this->view('email')
            ->subject('A new contact email')
            ->from('susheel.v2web@gmail.com')
            ->with('data',$this->user);
    }

}
