<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class UserApiRequest extends FormRequest { 


    public function authorize()
    {
        return true;
    }

    public function rules() {
        return [
            'name' => 'required',
            'email' => 'required|unique:users,email'
        ];
    }

    public function messages() {
        return [
            'email.required' => 'email id alrady exist'
        ];
    }

}
