<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\Services\Web\Service;
use App\Models\Disebility;
use App\Models\Speciality;

class HomeController extends Controller {

    protected $service; 
    public function __construct(
        Service $service 
        ) {
        $this->service = $service;          
    }

    // Home Page
    public function index() {
        return view('web.index');
    }

    // Registation Page
    public function mentorRegister() {
        $specialities = Speciality::get(); 
        return view('web.mentor_register', compact('specialities'));
    }

    // Registation Page
    public function mentorStore(Request $request) { 
        $this->service->mentorStore($request);
        return redirect()->back()->with('message',"This Mentor & Trainer  added Successfully !");
    } 

    // People Registation Page
    public function peopleRegister() {
        $disebilities = Disebility::get(); 
        return view('web.people_register', compact('disebilities'));
    }

    // Registation Page
    public function peopleStore(Request $request) { 
        $this->service->peopleStore($request);
        return redirect()->back()->with('message',"This People added Successfully !");
    }
    
    public function privacyPolicy(){
        //echo "ysdry";die();
        return view('web.privacy_policy');
    }
   

}
