<?php

namespace App\Http\Controllers\Mentor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Auth;
use Hash;

class MentorController extends Controller {

    // Mentor Home Page
    public function index() {
        $totalUser = User::where('role', 2)->count();
        $activeUser = User::whereNotNull('last_seen')->orderBy('last_seen')->count();
        return view('mentor.home', compact('totalUser', 'activeUser'));
    }
 
    // My Profile
    public function profile(){ 
        $users = Auth::user();
        return view('mentor.profile.index', compact('users')); 
    }

    // change password 
    public function changePassword(){  
        return view('mentor.profile.changePassword'); 
    }

    // Update Password
    public function updatePassword(Request $request) {
        # Validation
        $request->validate([
            'old_password' => 'required',
            'new_password' => 'required|confirmed',
        ]); 

        #Match The Old Password
        if(!Hash::check($request->old_password, auth()->user()->password)){
            return back()->with("error", "Old Password Doesn't match!");
        } 

        #Update the new Password
        User::whereId(auth()->user()->id)->update([
            'password' => Hash::make($request->new_password)
        ]); 
        
        return back()->with("status", "Password changed successfully!");
    }
 
}
