<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TutorialUpload;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Http\Requests\Admin\VideoRequest; 
use App\Services\Admin\TutorialUploadeService;
use App\Models\User;
use Auth;
use unlink;

class VideoController extends Controller
{
    
        protected $TutorialUploadeService;

    public function __construct(tutorialuploadeservice $tutorialuploadeservice) {   
        $this->tutorialuploadeservice = $tutorialuploadeservice;
    }
    public function index(){
      //  dd('test');
       $teacher= User::where('role', '=', '1')
       ->get();
         $tutorial = TutorialUpload::orderBy('id')->get();
        return view('admin.video.create',['user'=>$teacher]);
        
    }
    
    public function store(VideoRequest $request){
    // dd($request);
        $this->tutorialuploadeservice->Videostore($request); 
        return redirect()->route('video.list')->with('success','File Uploaded Successfully.');
    }
    public function video_list(){
          $video_list = TutorialUpload::orderBy('id')->get();
        // dd($mentors);
        return view('admin.video.list',['video_list'=>$video_list]);
    }
        public function edit($id){
        $admin= TutorialUpload::find($id);
        $allTeacher= User::where('role', '=', '1')
       ->get();
     $assign_teac_id=explode(",",$admin['assign_teac_id']);
    // $addedTeacher='';
     foreach($assign_teac_id as $index => $assignTeacher){
          $addedTeacher[$index]= User::where('id', '=', $assignTeacher)
       ->get();
     
     }
     
    //  foreach($allTeacher as $kay => $allTeacherResult){
    //      $id= $allTeacherResult->id;
    //      echo $id;
    //  } die();
    // dd(compact('addedTeacher'));
 
//return view('admin.video.edit', compact('admin', 'addedTeacher','allTeacher'));
   return view('admin.video.edit',['admin'=>$admin,'addedTeacher'=>$addedTeacher, 'allTeacher'=>$allTeacher]);
    }
    
     public function update(VideoRequest $request, $id){ 
        $mentors = TutorialUpload::find($id);
        $mentors->content = $request->content;
        $mentors->heading = $request->heading;
        $mentors->assign_teac_id =  implode(",",$request->assign_teac_id);
        
        if($request->hasfile('video_file')){
            $destination = '/video_file'.$mentors->video_file;
            if(File::exists($destination)){
                unlink($destination);
                File::delete($destination);
            }
            $ext = $request->video_file->getClientOriginalExtension();
            $newfilename = time().'.'.$ext;
            $request->video_file->move(public_path().'/video_file',$newfilename);
            $mentors->video_file = $newfilename;
            $mentors->save();
        }

        if($request->hasfile('pdf_file')){
            $destination = '/pdf_file'.$mentors->pdf_file;
            if(File::exists($destination)){
                unlink($destination);
                File::delete($destination);
            }
            $ext = $request->pdf_file->getClientOriginalExtension();
            $newfilename = time().'.'.$ext;
            $request->pdf_file->move(public_path().'/pdf_file',$newfilename);
            $mentors->pdf_file = $newfilename;
            $mentors->save();
        }

        return redirect()->route('video.list')->with('success','File Updated Successfully.');
        
         
     }
     
      public function destroy(Request $request, $id){
        $video = TutorialUpload::findOrFail($id);
        $file_path = public_path("/video_file{$video->id}"); 
        $video->delete(); 
        return redirect()->route('video.list')->with('success','File Updated Successfully.');
    }
    
        public function statusUpdate($id){
        $allUsers  = TutorialUpload::select('status')
            ->where('id','=',$id)
            ->first();
        //check user status
        if($allUsers->status=='0'){
            $status ='1';
        } else {
            $status ='0';
        }
        //update status
        $values =array('status'=>$status);
        $allUsers  = TutorialUpload::where('id',$id)->update($values);
        session()->flash('msg','Tutorial upadated successfully');
        return redirect('admin/all_video');
    } 
}
