<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Role;
use App\Http\Requests\Admin\RoleRequest;
use App\Services\Admin\RoleService;

class RoleController extends Controller {

    protected $RoleService;

    public function __construct(
        RoleService $roleservice
    ) {   
        $this->roleservice = $roleservice;
    }

    // Role Index
    public function index(){     
        $roles = Role::orderBy('id')->get();      
        return view('admin.role.index', ['roles'=> $roles]); 
    }

    // Role Create
    public function create(Request $request){
        return view('admin.role.create');
    }

    // Role Store
    public function store(RoleRequest $request) { 
        $this->roleservice->roleStore($request);
        return redirect()->route('role.index')->with('message',"This Role added Successfully !");
    }

    // Role Edit
    public function edit($id){
        $roles = Role::findOrFail($id);
        return view('admin.role.edit',['roles' => $roles]);
    }

    // Role Update
    public function update($id, Request $request){
        $roles = Role::findOrFail($id); 
        $roles->id = $request->id;
        $roles->name = $request->name; 
        $roles->save();
        return redirect()->route('role.index')->with('success','User update successfully.');
    }

    // public function update(Request $request){
    //     $this->roleservice->roleUpdate($request);
    //     return redirect()->route('role.index')->with('message',"This Role update Successfully !");
    // }
    
    // Role Delete
    public function destroy($id){
        $this->roleservice->deleteRoleById($id);
        return redirect()->route('role.index')->with('success','Disebility  Deleted successfully.');
    }

}