<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Admin\FaqService;
use App\Models\Faq; 

class FaqController extends Controller {
    
    protected $FaqService;

    public function __construct(
        FaqService $faqservice
    ) {   
        $this->faqservice = $faqservice;
    }

    // Faq Index
    public function index(){   
        $faqs = Faq::all();
        return view('admin.faq.index', compact('faqs')); 
    }

    // Faq Creat
    public function create(){   
        return view('admin.faq.create'); 
    }

    // Faq Store
    public function faqStore(Request $request) { 
        $this->faqservice->faqStore($request);
        return redirect()->route('faq.index')->with('message',"This Faq added Successfully !");
    }

    // Faq Edit
    public function edit($id){
        $faqs = Faq::findOrFail($id);
        return view('admin.faq.edit', compact('faqs'));
    }

    // Faq Update
    public function update($id, Request $request){
        $roles = Faq::findOrFail($id); 
        $roles->id = $request->id;
        $roles->question = $request->question; 
        $roles->answer = $request->answer; 
        $roles->save();
        return redirect()->route('faq.index')->with('success','Faq update successfully.');
    }

    // Faq Delete
    public function destroy($id){
        $this->faqservice->deleteFaqById($id);
        return redirect()->route('faq.index')->with('success','Faq  Deleted successfully.');
    }

}
