<?php

namespace App\Services\Api;
use Illuminate\Http\Request;  
use App\Models\TutorialUpload;  

class tutorialuploadeservice {
   
    //  Add Tutorial
    public function addTutorial(Request $request){
        $mentors = new TutorialUpload();  
        $mentors->id = $request->id; 
        $mentors->user_id = $request->user_id; 
        $mentors->title = $request->title;
        $mentors->content = $request->content;   

        if($request->video_file){
            $ext = $request->video_file->getClientOriginalExtension();
            $newfilename = time().'.'.$ext;
            $request->video_file->move(public_path().'/video_file',$newfilename);
            $mentors->video_file = $newfilename; 
        }  

        if($request->pdf_file){
            $ext = $request->pdf_file->getClientOriginalExtension();
            $newfilenames = time().'.'.$ext;
            $request->pdf_file->move(public_path().'/pdf_file',$newfilenames);
            $mentors->pdf_file = $newfilenames; 
        }   
        $data= $mentors->save();

        return response()->json([
            'succes' => "true", 
            'message' => 'File has been uploaded.',  
        ], 201);
         
    } 

    //  Student Tutorial
    public function studentCount(){     
        $studentCount = User::where('role', 10)->count();
        return response()->json([
            'succes' => 'true', 
            'message' => 'get all student', 
            'total student' => $studentCount,  
        ], 201);
    }

    //  All Active Tutorial
    public function activeTutorial(){     
        $activeTutorial = TutorialUpload::where('status', 1)->count();
        return response()->json([
            'succes' => 'true', 
            'message' => 'get all active tutorial', 
            'active tutorial' => $activeTutorial,  
        ], 201);
    }
    
    //  Show Student Tutorial
    public function showTutorial(){     
        $showAllTutorial = TutorialUpload::get();
        return response()->json([
            'succes' => 'true', 
            'message' => 'show all tutorial', 
            'total student' => $showAllTutorial,  
        ], 201);
    }

    //  All Disable Tutorial
    public function disableTutorial(){     
        $disableTutorial = TutorialUpload::where('status', 0)->count();
        return response()->json([
            'succes' => 'true', 
            'message' => 'get all disable tutorial', 
            'disable tutorial' => $disableTutorial,  
        ], 201);
    }

    //  All Tutorial
    public function allTutorial(){     
        $allTutorial = TutorialUpload::all()->count();
        return response()->json([
            'succes' => 'true', 
            'message' => 'get all tutorial', 
            'all tutorial' => $allTutorial,  
        ], 201);
    }
   
}