<?php

namespace App\Models;
 
use Illuminate\Foundation\Auth\User as Authenticatable; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use App\Models\UserDetail;

class User extends Authenticatable { 

    use HasApiTokens;

    protected $table = 'users';
    protected $fillable = [
        'name',
        'email',
        'password',
        'cleanpass',
        'role',     
        'last_seen',
        'mobile_number',
        'created_at',
        'updated_at'
    ];

    // public function roleRelation() {
    //     return $this->belongsTo(Role::class);
    // }
  
    public function userDetail() {
        return $this->hasOne(UserDetail::class, 'user_id', 'id');
    }

    public function roles() {
        return $this->hasOne(Role::class, 'id', 'name');
    }

}
