<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;
use Illuminate\Http\Request;
use App\Models\PasswordReset;
use Illuminate\Support\Str;
use Illuminate\Support\Carbon; 
use App\Models\User;

class ForgotPasswordController extends Controller {
    
    // User forget password
    public function forgetPassword(Request $request){  
        try {

            $user = User::where('email', $request->email)->get();

            if(count($user) > 0){

                $token = Str::random(40);
                $domain = URL::to('/');
                $url = $domain.'/reset-password?token='.$token;

                $data['url'] = $url;
                $data['email'] = $request->email;
                $data['title'] = "Password Reset";
                $data['body'] = "Please click on below link to reset your password.";

                Mail::send('forgetPasswordMail',['data'=>$data], function($message) use ($data){
                    $message->to($data['email'])->subject($data['title']); 
                });

                $datetime = Carbon::now()->format('Y-m-d H:i:s');
                PasswordReset::updateOrCreate(
                    ['email' => $request->email],
                    [
                        'email' => $request->email,
                        'token' => $token,
                        'created_at' => $datetime
                    ]
                );

                return response()->json(['success' =>true, 'msg'=>'Please check your mail to reset your password.']);

            } else {
                return response()->json(['success' =>"false", 'msg'=>'User not found!']);
            }
            
        }
        catch(\Exception $e) {
            return response()->json(['succes' =>false,'msg'=>$e->getMessage()]);
        }

    }

    // reset password view load
    public function resetPasswordLoad(Request $request){  
        // echo('hello'); die;
        $resetData = PasswordReset::where('token', $request->token)->get();

        if(isset($request->token) && count($resetData) > 0){
            
            $user = User::where('email', $resetData[0]['email'])->get(); 
            return view('resetPassword', compact('user'));
            // return response()->json(['succes' =>false, 'msg'=>'User not found!']);


        } else {
            return view('404');
        }
    }

    // password reset functionality
    public function resetPassword(Request $request){ 
       
        $request->validate([
            'password' => 'required|string|min:6|confirmed'
        ]);

        $user = User::find($request->id);
        $user->password = Hash::make($request->password);
        $user->save();

        PasswordReset::where('email', $user->email)->delete();

        // return "<h1>your password has been reset successfully.</h1>";
        return response()->json([
            'succes' =>false, 
            'msg'=>'your password has been reset successfully!.'
        ]);
        
    } 

}
