<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TermsAndCondition;

class TermsAndConditionController extends Controller {

    public function index() { 
        $terms = TermsAndCondition::all();
        // dd($terms);
    	return view('admin.termsAndCondition.index', compact('terms'));
    } 

    // user create
    public function create() { 
        $terms = TermsAndCondition::get();
    	return view('admin.termsAndCondition.create', compact('terms'));
    } 

    // user store
    public function store(Request $request) { 
        $terms = new TermsAndCondition(); 
        $terms->id = $request->id; 
        $terms->heading = $request->heading; 
        $terms->description	 = $request->description	; 
        $terms->save();
        return redirect()->route('admin.termsAndCondition.index')->with('message',"This Terms & Conditions added Successfully !");
    }

    // // user edit
    public function edit(TermsAndCondition $terms){ 
        // $terms = TermsAndCondition::get($id); 
        return view('admin.termsAndCondition.edit',compact('terms'));
    }

    // // user update
    public function update( TermsAndCondition $terms, Request $request){
        $terms->update([
            'heading' => $request->heading,
            'description' => $request->description, 
        ]);  

        $terms->save();
        return redirect()->route('admin.termsAndCondition.index')->with('message',"This Data Updated Successfully !");
    }

    // // user delete
    public function destroy($id) { 
        $terms = TermsAndCondition::findOrFail($id); 
        $terms->delete();
        return redirect()->route('admin.termsAndCondition.index')->with('message',"This Data Deleted Successfully !");
  }

}