<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\Admin\AllUsersService;
use App\Http\Requests\Admin\StoreRequest;
use Illuminate\Http\Request; 
use App\Models\User;
use App\Models\UserDetail;
use App\Models\Role;

class AllUsersController extends Controller {

    protected $AllUsersService;

    public function __construct(AllUsersService $allusersservice) {   
        $this->allusersservice = $allusersservice;
    }

    public function index() {
        $users = User::all();
        // $roles =Role::all('name');
    	return view('admin.alluser.index', compact('users'));
    } 

    // user create
    public function create() { 
        $roles = Role::get();
    	return view('admin.alluser.create', compact('roles'));
    } 

    // user store
    public function store(Request $request) { 
        $this->allusersservice->userStore($request);
        return redirect()->route('all.users')->with('message',"This User added Successfully !");
    }

    // user edit
    public function edit(User $users){ 
        $roles = Role::get(); 
        return view('admin.alluser.edit',compact('users','roles' ));
    }

    // user update
    public function update(User $users, Request $request){
        $users->update([
            'name' => $request->name,
            'email' => $request->email,
            'role' => $request->role,
        ]); 
       
        $users->UserDetail()->update([
            'user_id' => $users->id,
            'time' => $request->time,
            'location' => $request->location,
            'address' => $request->address,  
        ]);

        $users->save();
        return redirect()->route('all.users')->with('message',"This User Updated Successfully !");
    }

    // user delete
    public function destroy($id, Request $request) {
        $users = User::findOrFail($id);
        $users->delete();
        $users->UserDetail()->delete();
        return redirect()->route('all.users')->with('success','user Parmanently Deleted successfully.');
    }

    // Status Change
    public function statusUpdate($id){
        $allUsers  = User::select('status')
            ->where('id','=',$id)
            ->first();
        //check user status
        if($allUsers->status=='0'){
            $status ='1';
        } else if ($allUsers->status=='1'){
            $status ='2';
        } else {
            $status ='0';
        }
        //update status
        $values =array('status'=>$status);
        $allUsers  = User::where('id',$id)->update($values);
        session()->flash('msg','user upadated successfully');
        return redirect('admin/all-users');  
    } 
       
    // pending Status function
    public function pending_status() {  
        $pendingUser = User::where('status', 0)->get();
    	return view('admin.alluser.pending', compact('pendingUser'));
    }   

    // approve Status function
    public function approve_status() {  
        $approveUser = User::where('status', 1)->get();
    	return view('admin.alluser.approve', compact('approveUser'));
    }  

    // reject Status function
    public function reject_status() {  
        $rejectUser = User::where('status', 2)->get();
    	return view('admin.alluser.reject', compact('rejectUser'));
    }
    
    // get student function
    public function getTeacher(){
        $teachers = User::where('role', 9)->get(); 
		return view('admin.alluser.teacher', compact('teachers'));
	}

    // get teacher function
    public function getStudent(){
        $students = User::where('role', 10)->get();
		return view('admin.alluser.student', compact('students'));
	} 

}