
<?php $__env->startSection('content'); ?>
<!-- testing -->
<div class="nk-wrap ">
    <div class="nk-header nk-header-fixed is-light"></div>
    <!-- content @s  -->
    <div class="nk-content ">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="nk-block-head nk-block-head-sm">
                        <div class="nk-block-between">
                            <div class="nk-block-head-content">
                                <h3 class="nk-block-title page-title">Admin Dashboard</h3>
                                <div class="nk-block-des text-soft">
                                    <p>Welcome to Admin Dashboard.</p>
                                </div>
                            </div>
                        </div><!-- .nk-block-between -->
                    </div><!-- .nk-block-head -->
                    <div class="nk-block">
                        <div class="row g-gs"> 
                            <!-- Card -->
                            <div class="col-md-4">
                                <div class="card card_style1">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="mr-2">
                                                <span class="btn btn-circle btn-lg bg-primary">
                                                    <em class="icon ni ni-brick-fill text-white"></em>
                                                </span>
                                            </div>
                                            <div>
                                                Total Users
                                            </div>
                                            <div class="ml-auto">
                                                <h2 class="m-b-0 font-light"><?php echo e($alluser); ?></h2>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>      
                            <div class="col-md-4">
                                <div class="card card_style1">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="mr-2">
                                                <span class="btn btn-circle btn-lg bg-info">
                                                    <em class="icon ni ni-loader text-white"></em>
                                                </span>
                                            </div>
                                            <div>
                                                Pending Users
                                            </div>
                                            <div class="ml-auto">
                                                <h2 class="m-b-0 font-light"><?php echo e($pendingUser); ?></h2>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card card_style1">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="mr-2">
                                                <span class="btn btn-circle btn-lg bg-danger">
                                                    <em class="icon ni ni-cross-c text-white"></em>
                                                </span>
                                            </div>
                                            <div>
                                                Rejected Users
                                            </div>
                                            <div class="ml-auto">
                                                <h2 class="m-b-0 font-light"><?php echo e($rejectUser); ?></h2>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card card_style1">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="mr-2">
                                                <span class="btn btn-circle btn-lg bg-success">
                                                <em class="icon ni ni-check-circle-cut text-white"></em>
                                                </span>
                                            </div>
                                            <div>
                                                Approved Users
                                            </div>
                                            <div class="ml-auto">
                                                <h2 class="m-b-0 font-light"><?php echo e($approveUser); ?></h2>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="nk-block nk-block-lg">
                        <div class="nk-block-head">
                            <div class="nk-block-head-content">
                                <h4 class="nk-block-title">Active User List</h4>
                                <div class="nk-block-des">
                                    <p>Show All Active User</p>
                                </div>
                            </div>
                        </div> 
                        <div class="card card-preview">
                            <div class="card-inner">
                                <table class="datatable-init nowrap table">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if($activeUser->isNotEmpty()): ?>  
                                        <?php $__currentLoopData = $activeUser; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($user->id); ?></td>
                                            <td><?php echo e($user->name); ?></td>
                                            <td><?php echo e($user->email); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($user->last_seen)->diffForHumans()); ?></td>
                                            <td>
                                                <?php if(Cache::has('user-is-online-'.$user->id)): ?>
                                                <span class="text-center"><font color="green">Online</span>
                                                <?php else: ?>
                                                <span class="text-center"><font color="red"> Offline</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devtestv2/public_html/lessoning/resources/views/admin/home.blade.php ENDPATH**/ ?>