@extends('mentor.layouts.app')
@section('content')

<div class="nk-wrap "> 
    <!-- main header @s -->
    <div class="nk-header nk-header-fixed is-light"></div> 
    <!-- main header @e -->
    <!-- content @s -->
    <div class="nk-content ">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="nk-block-head nk-block-head-sm">
                        <div class="nk-block-between">
                            <div class="nk-block-head-content">
                                <h3 class="nk-block-title page-title">Mentor Profile</h3>
                                <div class="nk-block-des text-soft">
                                    <p>Welcome to Mentor Dashboard.</p>
                                </div>
                            </div>
                        </div>
                    </div> 
                    <div class="nk-block">
                        <div class="nk-data data-list">
                            <div class="data-head">
                                <h6 class="overline-title">Basics</h6>
                            </div>
                            <div class="data-item" data-toggle="modal" data-target="#profile-edit">
                                <div class="data-col">
                                    <span class="data-label">Full Name</span>
                                    <span class="data-value">{{ $users->name }}</span>
                                </div>
                                <div class="data-col data-col-end"></div>
                            </div>
                            <!-- <div class="data-item" data-toggle="modal" data-target="#profile-edit">
                                <div class="data-col">
                                    <span class="data-label">Display Name</span>
                                    <span class="data-value">Ishtiyak</span>
                                </div>
                                <div class="data-col data-col-end"></div>
                            </div> --> 
                            <div class="data-item">
                                <div class="data-col">
                                    <span class="data-label">Email</span>
                                    <span class="data-value">{{ $users->email }}</span>
                                </div>
                                <div class="data-col data-col-end"></div>
                            </div>
                            <div class="data-item" data-toggle="modal" data-target="#profile-edit">
                                <div class="data-col">
                                    <span class="data-label">Phone Number</span>
                                    <span class="data-value text-soft">{{ $users->mobile_number }}</span>
                                </div>
                                <div class="data-col data-col-end"></div>
                            </div>
                            <!-- <div class="data-item" data-toggle="modal" data-target="#profile-edit">
                                <div class="data-col">
                                    <span class="data-label">Date of Birth</span>
                                    <span class="data-value">29 Feb, 1986</span>
                                </div>
                                <div class="data-col data-col-end"></div>
                            </div> --> 
                            <div class="data-item" data-toggle="modal" data-target="#profile-edit" data-tab-target="#address">
                                <div class="data-col">
                                    <span class="data-label">Address</span>
                                    <span class="data-value">{{ $users->address }}<br>{{ $users->address }}</span>
                                </div>
                                <div class="data-col data-col-end"></div>
                            </div>
                        </div>
                        <!-- <div class="nk-data data-list">
                            <div class="data-head">
                                <h6 class="overline-title">Preferences</h6>
                            </div>
                            <div class="data-item">
                                <div class="data-col">
                                    <span class="data-label">Language</span>
                                    <span class="data-value">English (United State)</span>
                                </div>
                                <div class="data-col data-col-end"><a href="#" data-toggle="modal" data-target="#profile-language" class="link link-primary">Change Language</a></div>
                            </div>
                            <div class="data-item">
                                <div class="data-col">
                                    <span class="data-label">Date Format</span>
                                    <span class="data-value">M d, YYYY</span>
                                </div>
                                <div class="data-col data-col-end"><a href="#" data-toggle="modal" data-target="#profile-language" class="link link-primary">Change</a></div>
                            </div>
                            <div class="data-item">
                                <div class="data-col">
                                    <span class="data-label">Timezone</span>
                                    <span class="data-value">Bangladesh (GMT +6)</span>
                                </div>
                                <div class="data-col data-col-end"><a href="#" data-toggle="modal" data-target="#profile-language" class="link link-primary">Change</a></div>
                            </div>
                        </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection