@extends('admin.layouts.app')
@section('content')
<div class="nk-wrap "> 
    <div class="nk-header nk-header-fixed is-light"></div> 
        <div class="nk-content ">
            <div class="container-fluid">
                <div class="nk-content-inner">
                    <div class="nk-content-body">
                        @if(session()->has('message'))
                        <div class="alert alert-success">
                            {{ session()->get('message') }}
                        </div>
                        @endif
                    <div class="nk-block-head nk-block-head-sm">
                        <div class="nk-block-between">
                            <div class="nk-block-head-content">
                                <h3 class="nk-block-title page-title">Edit Files</h3>
                            </div>
                        </div> 
                    </div> 
                    <div class="form-group">
                        <div class="card card-preview">
                            <div class="card-inner">
                                <div class="preview-block">
                                   <form method="post" action="{{route('video.update',$admin->id)}}" enctype="multipart/form-data">
                                        @csrf
                                        @method('PUT')
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label class="form-label" for="default-01">Content <span class="text-danger"></span></label>
                                                <div class="form-control-wrap">
                                                <input type="text" class="form-control @error('content') is-invalid @enderror" id="content" name="content" placeholder="Content"  value="{{old('content', $admin->content)}}">
                                                @error('content')
                                                <p class="invalid-feedback">{{$message}}</p>
                                                @enderror 
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label class="form-label" for="default-01">Heading <span class="text-danger"></span></label>
                                                <div class="form-control-wrap">
                                                <input type="text" class="form-control @error('heading') is-invalid @enderror" id="heading" name="heading" placeholder="heading" value="{{old('heading', $admin->heading)}}">
                                                @error('heading')
                                                <p class="invalid-feedback">{{$message}}</p>
                                                @enderror 
                                                </div>
                                            </div>
                                        </div>
                                        <br>                       
                                        <div class="col-sm-6">
                                            <label for="default-01">Video File<span class="text-danger"></span></label>
                                            <div class="form-control-wrap">
                                            <input type="file" class="form-control @error('video_file') is-invalid @enderror" id="video_file" name="video_file"  value="{{old('video_file', $admin->video_file)}}">                                             
                                              
                                                      <video controls>
                                                <source src="{{ asset("video_file/$admin->video_file") }}" type="video/mp4" width="100px" height="80px">
                                            </video>
                                                
                                                @error('video_file')
                                                <p class="invalid-feedback">{{$message}}</p>
                                                @enderror 
                                            </div>
                                        </div>
                                                                                <br>                       
                                        <div class="col-sm-6">
                                            <label for="default-01">Pdf File<span class="text-danger"></span></label>
                                            <div class="form-control-wrap">
                                            <input type="file" class="form-control @error('pdf_file') is-invalid @enderror" id="pdf_file" name="pdf_file"  value="{{old('pdf_file', $admin->video_file)}}">                                             
                                              <a href="{{asset("pdf_file/$admin->pdf_file") }}" target="_blank">PDF</a>
                                                   
                                                @error('pdf_file')
                                                <p class="invalid-feedback">{{$message}}</p>
                                                @enderror 
                                            </div>
                                        </div>
                                        <br>
                                      
                                             <div class="row gy-4"> 
                                            <div class="col-sm-12">
                                            <label class="form-label" for="default-01">Assign Video <span class="text-danger">*</span></label>
                                                <div class="form-control-wrap">
                                                    <select multiple="multiple" class="form-select" name="assign_teac_id[]">
                                                         @foreach($allTeacher as $index => $userList)
                                                      <option value="{{ $userList->id}}"> {{ $userList->name}}</option>
                                                        @endforeach
                                                        
                                                       @foreach($addedTeacher as $userListAdded)
                                                      <option value="{{ $userListAdded[0]->id}}" selected> {{ $userListAdded[0]->name}}</option>
                                                        @endforeach
                                                        
                                                    </select>
                                                  
                                                </div>
                                            </div>
                                        </div> 
                                        <br>
                                        <button type="submit">Submit</button>   
                                    </form>
                                </div>
                            </div>
                        </div> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection