@extends('admin.layouts.app')
@section('content')

<div class="nk-wrap "> 
    <div class="nk-header nk-header-fixed is-light"></div> 
    <div class="nk-content ">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="form-group">
                        <div class="card card-preview">
                            <div class="card-inner">
                                <!-- <div class="preview-block">
                                    <span class="preview-title-lg overline-title">Default Preview</span>
                                </div> -->
                                <div class="nk-block nk-block-lg">
                                    <div class="nk-block-head">
                                        <div class="nk-block-head-content nk-block-head-content d-flex justify-content-between align-items-center">
                                            <h4 class="nk-block-title">Show All FAQ</h4> 
                                            <a href="{{ route('faq.create') }}" class="btn btn-primary">Create FAQ</a>
                                        </div>
                                    </div>
                                    <div class="card card-preview">
                                        <div class="card-inner">
                                            <table class="datatable-init nowrap table">
                                                <thead>
                                                    <tr>
                                                        <th>id</th>
                                                        <th>Question</th>
                                                        <th>Answers</th> 
                                                        <th>Action</th>  
                                                    </tr>
                                                </thead>
                                                <tbody>  
                                                    <?php $i = 0; ?>
                                                    @foreach($faqs as $faq)
                                                    <tr>
                                                        <?php $i++; ?>
                                                        <td>{{ $i }}</td>
                                                        <td>{{ $faq->question }}</td>
                                                        <td>{{ $faq->answer }}</td> 
                                                        <td>
                                                            <a href="{{ route('faq.edit',$faq->id) }}" class="btn btn-primary btn-sm">Edit</a> 
                                                            <a onclick="deleteUser({{ $faq->id }})" class="btn btn-danger btn-sm">Delete</a>
                                                            <form id="user-edit-action-{{ $faq->id }}" action="{{ route('faq.destroy',$faq->id) }}" method="post">
                                                                @csrf
                                                                @method('delete')
                                                            </form> 
                                                        </td>            
                                                    </tr> 
                                                    @endforeach 
                                                </tbody>
                                            </table>
                                        </div>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
 </div>
 <script>
   function deleteUser(id) {
       if (confirm("Are you sure you want to delete?")) {
           document.getElementById('user-edit-action-'+id).submit();
       }
   }
</script>
    @endsection