@extends('admin.layouts.app')
@section('content')

<div class="nk-wrap "> 
    <div class="nk-header nk-header-fixed is-light"></div> 
    <div class="nk-content ">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="form-group">
                        <div class="card card-preview">
                            <div class="card-inner">
                                <!-- <div class="preview-block">
                                    <span class="preview-title-lg overline-title">Default Preview</span>
                                </div> -->
                                <div class="nk-block nk-block-lg">
                                    <div class="nk-block-head">
                                        <div class="nk-block-head-content nk-block-head-content d-flex justify-content-between align-items-center">
                                            <h4 class="nk-block-title">Show All Mentor & Trainer</h4> 
                                            <a href="{{ route('create.users') }}" class="btn btn-primary">Add Mentor</a>
                                        </div>
                                    </div>
                                    <div class="card card-preview">
                                        <div class="card-inner">
                                            <table class="datatable-init nowrap table">
                                                <thead>
                                                    <tr>
                                                        <th>Name</th>
                                                        <th>Email</th>
                                                        <th>Disability</th>
                                                        <th>User Type</th>
                                                        <th>Address</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody> 
                                                    <?php $i = 0; ?>
                                                    @foreach($approveUser as $approve)
                                                    <tr>
                                                        <?php $i++; ?>
                                                        <td>{{ $i }}</td>
                                                        <td>{{ $approve->name }}</td>
                                                        <td>{{ $approve->email }}</td>
                                                        <td>{{ $approve->role }}</td> 
                                                        <td>{{ $approve->address }}</td>
                                                        <td>
                                                            <?php if($approve->status == 0){ ?>  
                                                                <a href="{{url('admin/status-update',$approve->id)}}" class="btn btn-warning">Pending</a>
                                                            <?php } elseif ($approve->status == 1) {?>
                                                                <a href="{{url('admin/status-update',$approve->id)}}" class="btn btn-primary">Aprove</a>
                                                            <?php } else {?>
                                                                <a href="{{url('admin/status-update',$approve->id)}}" class="btn btn-danger">Reject</a>
                                                            <?php } ?> 
                                                        </td>              
                                                    </tr> 
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection