@extends('admin.layouts.app')
@section('content')

<div class="nk-wrap "> 
    <div class="nk-header nk-header-fixed is-light"></div> 
    <div class="nk-content ">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="form-group"> 
                        @if(session()->has('success'))
                            <div class="alert alert-success">
                            {{ session()->get('success') }}
                            </div>
                        @endif
                        <div class="card card-preview">
                            <div class="card-inner">
                                <!-- <div class="preview-block">
                                    <span class="preview-title-lg overline-title">Default Preview</span>
                                </div> -->
                                <div class="nk-block nk-block-lg">
                                    <div class="nk-block-head">
                                        <div class="nk-block-head-content nk-block-head-content d-flex justify-content-between align-items-center">
                                            <h4 class="nk-block-title">All Disebility</h4> 
                                            <a href="{{ route('disebility.create') }}" class="btn btn-primary">Add Disebility</a>
                                                                                    
                                        </div>
                                    </div>
                                    <div class="card card-preview">
                                        <div class="card-inner">
                                            <table class="datatable-init nowrap table">
                                                <thead>
                                                    <tr>
                                                        <th>ID</th>
                                                        <th>Disebilities</th>     
                                                        <th>Action</th>                                                 
                                                    </tr>
                                                </thead>
                                                <tbody>            
                                                    <?php $i = 0; ?>                                                                                                                                        
                                                    @foreach ($disebilities as $disebility)
                                                    <tr>       
                                                        <?php $i++; ?>
                                                        <td>{{ $i }}</td>             
                                                        <td>{{ $disebility->disebility }}</td>  
                                                        <td>
                                                        <a href="{{ route('disebility.edit',$disebility->id) }}" class="btn btn-primary btn-sm">Edit</a>
                                                    
                                                        <a onclick="deleteDisebility({{$disebility->id}})" class="btn btn-danger btn-sm">Delete</a>
                                                        <form id="disebility-edit-action-{{ $disebility->id }}" action="{{route('disebility.destroy',$disebility->id)}}" method="post">
                                                            @csrf
                                                            @method('delete')
                                                            </form>
                                                        </td>                                                    
                                                    </tr> 
                                                    @endforeach                                                                                                                                                 
                                                </tbody>
                                            </table>
                                        </div>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
   function deleteDisebility(id) {
       if (confirm("Are you sure you want to Delete?")) {
           document.getElementById('disebility-edit-action-'+id).submit();
       }
   }
</script>

    @endsection