@extends('admin.layouts.app')
@section('content')
<div class="nk-wrap ">
    <div class="nk-header nk-header-fixed is-light"></div>
    <div class="nk-content ">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="form-group">
                        <div class="card card-preview">
                            <div class="card-inner"> 
                                <div class="nk-block nk-block-lg">
                                <div class="nk-block-head">
                                    <div class="nk-block-head-content nk-block-head-content d-flex justify-content-between align-items-center">
                                        <h4 class="nk-block-title">All Students</h4>
                                        <!-- <a href="{{ route('create.users') }}" class="btn btn-primary">Add Teacher</a> -->
                                    </div>
                                </div>
                                <div class="card card-preview">
                                    <div class="card-inner">
                                        <table class="datatable-init nowrap table">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Email</th>
                                                    <th>Disability</th>
                                                    <th>User Type</th>
                                                    <th>Address</th>
                                                    <th>Time</th>
                                                    <th>location</th>
                                                    <th >Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            <?php $i = 0; ?>
                                            @foreach($students as $student)
                                            <tr>
                                                <?php $i++; ?>
                                                <td>{{ $i }}</td>
                                                <td>{{ $student->name }}</td>
                                                <td>{{ $student->email }}</td>
                                                <td>{{ $student->role }}</td>
                                                <td>{{ $student->UserDetail->address ?? ""}}</td>
                                                <td>{{ $student->UserDetail->time ?? "" }}</td>
                                                <td>{{ $student->UserDetail->location ?? "" }}</td>
                                                <td>
                                                    <a href="{{ route('edit',$student->id) }}" class="btn btn-primary btn-sm">Edit</a> 
                                                    <a onclick="deleteUser({{ $student->id }})" class="btn btn-danger btn-sm">Delete</a>
                                                    <form id="user-edit-action-{{ $student->id }}" action="{{ route('delete.users',$student->id) }}" method="post"> 
                                                        @csrf
                                                        @method('delete')
                                                    </form>
                                                </td>
                                                </td>    
                                            </tr>
                                            @endforeach 
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function deleteUser(id) {
        if (confirm("Are you sure you want to delete?")) {
            document.getElementById('user-edit-action-'+id).submit();
        }
    }
</script>
@endsection