<?php

namespace App\Services\Admin;
use Illuminate\Http\Request;  
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Mail;
use App\Mail\NewUserCreateMail;

use App\Models\User; 
use App\Models\UserDetail; 

class AllUsersService {
 
    public function userStore(Request $request){
        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'role' => $request->role,
            $str="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()-",  
                $password = substr(str_shuffle($str),0,10), 
                'password'=>password_hash($password, PASSWORD_DEFAULT),
                'cleanpass'=>$password,
                // dd($user);
                // $user->save()
                // $user->save()
            ]);
         
            $user = UserDetail::create([
            'user_id' => $user->id,
            'disability_category' => $request->disability_category,
            'speciality_category' => $request->speciality_category,
            'time' => $request->time,
            'location' => $request->location,
            'address' => $request->address,
            'special_condition' => $request->special_condition,
            // $user->save()
        ]);  

    }
}
