<?php

namespace App\Http\Middleware;

use Closure;
use Auth;
use App\Models\Permission;
use App\Models\Role;

class RoleAccess {

    /*
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */

    public function handle($request, Closure $next) {
        $routeName = $request->route()->getName();
        $role_id = Auth::user()->role;
        //dd(Auth::user()); 
        if(Auth::user()->role == '1' || Auth::user()->admin_user == 'admin') {
            return $next($request);
        }
        
        $check_permission = Permission::where('role_id',$role_id)
        ->whereRaw('json_contains(permission, \'["' . $routeName . '"]\')')->count();
        if( $check_permission > 0){
            return $next($request);
        } else  {
            return abort(403,"You Are Not Authorized to Access This Page");
        }
       
    }
}
