<?php

namespace App\Http\Controllers\Mentor;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TutorialUpload;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Http\Requests\Mentor\VideoRequest; 
use App\Services\Mentor\TutorialUploadeService;
use Auth;
use unlink;

class TutorialUploadeContoller extends Controller{

    protected $TutorialUploadeService;

    public function __construct(tutorialuploadeservice $tutorialuploadeservice) {   
        $this->tutorialuploadeservice = $tutorialuploadeservice;
    }

    public function index(){
        $mentors = TutorialUpload::orderBy('id')->get();
        // dd($mentors);
        return view('mentor.tutorials.index',['mentors'=>$mentors]);
    }

    public function create(Request $request) { 
        return view('mentor.tutorials.create');
    }

    public function store(VideoRequest $request){
        $this->tutorialuploadeservice->Videostore($request); 
        return redirect()->route('tutorial.index')->with('success','File Uploaded Successfully.');
    }  

    public function edit($id){
        $mentors= TutorialUpload::find($id);
        return view('mentor.tutorials.edit',compact('mentors'));
    }

    public function update(VideoRequest $request, $id){
        // $this->tutorialuploadeservice->VideoUpdate($request);
        $mentors = TutorialUpload::find($id);
        $mentors->content = $request->content;
        $mentors->heading = $request->heading;

        if($request->hasfile('video_file')){
            $destination = '/video_file'.$mentors->video_file;
            if(File::exists($destination)){
                unlink($destination);
                File::delete($destination);
            }
            $ext = $request->video_file->getClientOriginalExtension();
            $newfilename = time().'.'.$ext;
            $request->video_file->move(public_path().'/video_file',$newfilename);
            $mentors->video_file = $newfilename;
            $mentors->save();
        }

        if($request->hasfile('pdf_file')){
            $destination = '/pdf_file'.$mentors->pdf_file;
            if(File::exists($destination)){
                unlink($destination);
                File::delete($destination);
            }
            $ext = $request->pdf_file->getClientOriginalExtension();
            $newfilename = time().'.'.$ext;
            $request->pdf_file->move(public_path().'/pdf_file',$newfilename);
            $mentors->pdf_file = $newfilename;
            $mentors->save();
        }

        return redirect()->route('tutorial.index')->with('success','File Updated Successfully.');
        
    }  

    public function download($id){
        $mentors = DB::table('tutorial_uploads')->get();
        return view('mentor.tutorials.index',compact('mentors'));
    }

    public function destroy(Request $request, $id){
        $mentors = TutorialUpload::findOrFail($id);
        $file_path = public_path("/video_file{$mentors->id}"); 
        $mentors->delete(); 
        return redirect()->route('tutorial.index')->with('success','File Updated Successfully.');
    }

    // Status Change
    public function statusUpdate($id){
        $allUsers  = TutorialUpload::select('status')
            ->where('id','=',$id)
            ->first();
        //check user status
        if($allUsers->status=='0'){
            $status ='1';
        } else {
            $status ='0';
        }
        //update status
        $values =array('status'=>$status);
        $allUsers  = TutorialUpload::where('id',$id)->update($values);
        session()->flash('msg','Tutorial upadated successfully');
        return redirect('mentor/all-tutorial');
    } 
     
}
