<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Speciality;
use App\Http\Requests\Admin\SpecialityRequest;
use App\Services\Admin\SpecialityService;

class SpecialityController extends Controller {

    public function __construct( 
        SpecialityService $specialityservice
    ) {    
        $this->specialityservice= $specialityservice;   
    }

    // Speciality Index
    public function index(){     
        $specialities = Speciality::orderBy('id')->get();     
        return view('admin.speciality.index',['specialities'=> $specialities]);
    }

    // Speciality Create
    public function create(Request $request){ 
        return view('admin.speciality.create');
    }

    // Speciality Store 
    public function store(SpecialityRequest $request){
        $this->specialityservice->specialityStore($request);
        return redirect()->route('speciality.index')->with('success','Speciality created successfully.');
    }

    // Speciality Edit
    public function edit($id){
        $specialities = Speciality::find($id);
        return view('admin.speciality.edit',['specialities' => $specialities]);
    }  

    // Speciality Update
    public function update($id, Request $request){
        $specialities = Speciality::findOrFail($id); 
        $specialities->speciality = $request->speciality; 
        $specialities->save();
        return redirect()->route('speciality.index')->with('success','Speciality update successfully.');
    }

    // Speciality Delete
    public function destroy($id){
        $this->specialityservice->deleteSpecialityById($id);
        return redirect()->route('speciality.index')->with('success','Disebility  Deleted successfully.'); 
    }

}
