<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Disebility;
use App\Http\Requests\Admin\DisebilityRequest;
use App\Services\Admin\DisebilityService;

class DisebilityController extends Controller {

    protected $DisebilityService; 
    
    public function __construct(
        DisebilityService $disebilityservice
    ) {   
        $this->disebilityservice = $disebilityservice;
    }

    // Disebility index
    public function index(){     
        $disebilities = Disebility::orderBy('id')->get();    
        return view('admin.disebility.index', ['disebilities'=> $disebilities]); 
    }

    // Disebility Create
    public function create(Request $request){
        return view('admin.disebility.create');
    }

    // Disebility Store
    public function store(DisebilityRequest $request){
        $this->disebilityservice->disebilityStore($request);
        return redirect()->route('disebility.index')->with('success','Disebility created successfully.');
    }

    // Disebility Edit
    public function edit($id){
        $disebilities = Disebility::find($id);
        return view('admin.disebility.edit',['disebilities' => $disebilities]);
    }

    // Disebility Update
    public function update($id, Request $request){
        $disebilities = Disebility::findOrFail($id);  
        $disebilities->disebility = $request->disebility; 
        $disebilities->save();
        return redirect()->route('disebility.index')->with('success','Disebility update successfully.');
    }
    
    // Disebility Delete
    public function destroy($id){
        $this->disebilityservice->deleteDisebilityById($id);
        return redirect()->route('disebility.index')->with('success','Disebility  Deleted successfully.');
    }
    
}
