<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Auth;

class AdminAuthController extends Controller {

    //load login view
    public function index(){
		return view('admin.login');
	}
    
    //check login
	// public function check(Request $request) {
	// 	$this->validate($request, [
	// 		'email' => 'required|email',
	// 		'password' => 'required|min:6'
	// 	]);
	// 	if (Auth::attempt(['email' => $request->email, 'password' => $request->password])) {
    //         return redirect('admin/dashboard')->withSuccess('You have logged in successfully!'); 
    //     } else {
    //         return redirect('admin/login')->withError('Username or password is wrong!'); 
	// 	}
	// }

    //check login
    public function check(Request $request) {
     
        $input = $request->all(); 
        $this->validate($request, [
            'email' => 'required|email',
            'password' => 'required',
        ]);
   
        if(auth()->attempt(array('email' => $input['email'], 'password' => $input['password']))) {
            if (auth()->user()->role == 8 && auth()->user()->status == 1) {
                return redirect()->route('admin.home')->withSuccess('You have logged in successfully!');
            } else if (auth()->user()->role == 1 && auth()->user()->status == 1) {
                return redirect()->route('mentor.home')->withSuccess('You have logged in successfully!');
            } else {
                return redirect()->route('user.home')->withError('Username or password is wrong!');
                // return redirect('home')->with('error', "You don't have admin access.");
            }
        } else {
            return redirect()->route('login')->with('error','Email-Address And Password Are Wrong.');
        }
          
    }

    // Admin Home Page
    public function adminHome() {
        $alluser = User::all()->count();
        $pendingUser = User::where('status', 0)->count();
        $rejectUser = User::where('status', 2)->count();
        $approveUser = User::where('status', 1)->count();
        $activeUser = User::select("*")->whereNotNull('last_seen')->orderBy('last_seen', 'DESC')->paginate(10);
        return view('admin.home', compact('alluser','pendingUser','rejectUser','approveUser', 'activeUser'));
    }

    //logout
	public function logout() {
		Auth::logout();
  		return redirect('admin/login');
	} 

}
