<?php

namespace App\Services\Web;
use Illuminate\Http\Request; 

use Illuminate\Support\Str;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Mail;
use App\Mail\NewUserCreateMail;
use App\Models\UserDetail; 
use App\Models\User; 

class Service {
 
    // Mentor Store Service
    public function mentorStore(Request $request){

        // store a data user table
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role = 9;
        $str="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()-";  
        $password = substr(str_shuffle($str),0,10); 
        $user->password=password_hash($password, PASSWORD_DEFAULT);
        $user->cleanpass=$password;
        $user->save(); 

        // store a data UserDetail table
        $address = new UserDetail();
        $address->user_id = $user->id;
        $address->speciality_category = $request->speciality_category; 
        $address->time = $request->time;
        $address->location = $request->location; 
        $address->address = $request->address;
        $address->special_condition = $request->special_condition;
        $address->save(); 

        $user = User::find($user->id);
        Mail::to($users = User::find($user->id))->send(new NewUserCreateMail($user));   
        if($user->save()){
            return $user;
        }

    }

    // People Store Service
    public function peopleStore(Request $request){

        // store a data user table
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role = 9;
        $str="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()-";  
        $password = substr(str_shuffle($str),0,10); 
        $user->password=password_hash($password, PASSWORD_DEFAULT);
        $user->cleanpass=$password;
        $user->save(); 

        // store a data UserDetail table
        $address = new UserDetail();
        $address->user_id = $user->id;
        $address->disability_category = $request->disability_category;
        $address->time = $request->time;
        $address->location = $request->location; 
        $address->address = $request->address;
        $address->special_condition = $request->special_condition;
        $address->save(); 

        $user = User::find($user->id);
        Mail::to($users = User::find($user->id))->send(new NewUserCreateMail($user));   
        if($user->save()){
            return $user;
        }
  
    }
   
}