<?php

namespace App\Services\Api;
use Illuminate\Http\Request; 

use Illuminate\Support\Str;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Carbon; 
use App\Mail\NewUserCreateMail;
use App\Models\UserDetail; 
use App\Models\PasswordReset;
use App\Models\UserOtp;
use App\Models\User;
use Auth;
use Hash;   

class LoginWithOtpService {
   
    // User login otp generate
    public function loginOtpGenerate(Request $request) {  

        $request->validate([
            'mobile_number' => 'required|exists:users,mobile_number',
        ]); 

        $userOtp = $this->generateOTP($request->mobile_number);  
        $userOtp->sendSMS($request->mobile_number); //send otp  

        return response()->json([
            'success' => true, 
            'message' => 'OTP sent to your mobile number', 
            'data' => [  
                'otp_code' => $userOtp->otp_code,
                'mobile_number' => $userOtp->mobile_number
            ]
        ], 200);

    } 

    // User login otp generate
    public function generateOTP($mobile_number) {   
        $user = User::where('mobile_number', $mobile_number)->first(); 
        $userOtp = UserOtp::where('user_id', $user->id)->latest()->first();    

        $now = now();

        if($userOtp && $now->isBefore($userOtp->expire_at)){
            return $userOtp;
        }

        return UserOtp::create([
            'mobile_number' => $user->mobile_number,
            'user_id' => $user->id,
            'otp_code' => rand(1234, 9999),
            'expire_at' => $now->addMinutes(10),
        ]); 

    }

    // User login With Otp
    public function loginWithOtp(Request $request){

        $request->validate([
            'otp_code' => 'required',
            'mobile_number' => 'required|exists:users,mobile_number',
        ]);

        $userOtp = UserOtp::where('mobile_number', $request->mobile_number)->where('otp_code', $request->otp_code)->first(); 

        $now = now();

        if(!$userOtp){
            return response()->json(['error' => false, 'message' => 'Your OTP does not match.!'], 200);
        } else if($userOtp && $now->isAfter($userOtp->expire_at)) {
            return response()->json(['error' => false, 'message' =>'Your OTP has been Expired.!'], 200);
        }

        $user = User::where('mobile_number', $request->mobile_number)->first();   

        if($user) {
            $userOtp->update([
                'expire_at' => now()
            ]);

            Auth::login($user);
            return response()->json([
                'success' =>true, 
                'message' => 'Login has been succesfully.!',
                'data' => [  
                    'user_id' => $user->id,
                    'username' => $user->name,
                    'email' => $user->email
                ]
            ], 200);
        }

        return response()->json(['success' =>false, 'message' => 'Your OTP is not correct.!'], 200);

    } 

    // User resend login otp generate
    public function resendLoginOtp(Request $request) {  

        $request->validate([
            'mobile_number' => 'required|exists:users,mobile_number',
        ]); 

        $userOtp = $this->resendOTP($request->mobile_number);  
        $userOtp->sendSMS($request->mobile_number); //send otp  

        return response()->json([
            'success' => true, 
            'message' => 'OTP resend sent to your mobile number', 
            'data' => [  
                'otp_code' => $userOtp->otp_code,
                'mobile_number' => $userOtp->mobile_number
            ]
        ], 200);

    }

    // User resend login otp generate
    public function resendOTP($mobile_number) {   
        $user = User::where('mobile_number', $mobile_number)->first(); 
        $userOtp = UserOtp::where('user_id', $user->id)->latest()->first();    

        $now = now();

        if($userOtp && $now->isBefore($userOtp->expire_at)){
            return $userOtp;
        }

        return UserOtp::create([
            'mobile_number' => $user->mobile_number,
            'user_id' => $user->id,
            'otp_code' => rand(1234, 9999),
            'expire_at' => $now->addMinutes(10),
        ]); 

    }
    
}