<?php

namespace App\Http\Controllers\Mentor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Pdf_Upload; 
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Http\Requests\Mentor\PdfRequest; 
use App\Services\Mentor\PdfService; 
use Auth;

class PdfController extends Controller {
     protected $PdfService;

     public function __construct(PdfService $PdfService) {   
         $this->PdfService = $PdfService;
     }
   
     public function index(){
          $mentors = Pdf_Upload::orderBy('id')->get();
          return view('mentor.pdf.index',['mentors'=>$mentors]);
     }

     public function create(PdfService $request) { 
          return view('mentor.pdf.create');
     } 

     public function store(PdfRequest $request){
          $this->PdfService->Pdfstore($request);
          return redirect()->route('pdf.index')->with('success','Pdf Uploaded Successfully.');
     }  

     public function edit($id){
          $mentors= Pdf_Upload::find($id);
          return view('mentor.pdf.edit',compact('mentors'));
     }


     public function update(PdfRequest $request, $id){
          // $this->PdfService->PdfUpdate($request);
          $mentors = Pdf_Upload::find($id);
          $mentors->content = $request->content;
          $mentors->heading = $request->heading; 
          if($request->hasfile('pdf_file')){ 
               $destination = '/pdf_file'.$mentors->pdf_file;

               if(File::exists($destination)){
                    File::delete($destination);
               }

               $ext = $request->pdf_file->getClientOriginalExtension();
               $newfilename = time().'.'.$ext;
               $request->pdf_file->move(public_path().'/pdf_file',$newfilename);
               $mentors->pdf_file = $newfilename;
               $mentors->save();
          }
          return redirect()->route('pdf.index')->with('success','Pdf Updated Successfully.');
     }  

     public function download($id){
          $mentors = DB::table('pdf_uploads')->get();
          return view('mentor.pdf.index',compact('mentors'));
     }

     public function destroy($id) {
          $mentors = Pdf_Upload::findOrFail($id);
          $file_path = app_path("/pdf_file{$mentors->id}"); 
          $mentors->delete();
          return redirect()->route('pdf.index')->with('success','Pdf Updated Successfully.');
     }
       
}


