<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\Api\UserService;
use Illuminate\Http\Request; 
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Hash;
use App\Http\Requests\Api\UserApiRequest;
use Illuminate\Support\Str;
use Illuminate\Support\Carbon; 
use App\Models\PasswordReset;
use App\Models\User;
use App\Models\UserOtp;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller {

    protected $UserService; 

    public function __construct(UserService $userservice) {   
        $this->userservice = $userservice;
    }

    // User Register
    public function register(UserApiRequest $request) {
        // echo('hello'); die;
        try {
            return $this->userservice->register($request);
        }
        catch(\Exception $e) {
            return response(['message' => $e->getMessage()], 500);
        }
    }

    // User Login 
    public function login(Request $request){
        return $this->userservice->login($request);
    }

    // User Info
    public function userInfo(Request $request){
        return $this->userservice->userInfo($request);
    } 

    // User otp generate 
    public function otpGenerate(Request $request){
        return $this->userservice->otpGenerate($request);
    }  

    // User otp login With Otp 
    public function loginWithOtp(Request $request){
        return $this->userservice->loginWithOtp($request);
    }  
    
    // User resend Otp
    public function resendOtp(Request $request){
        return $this->userservice->resendOtp($request);
    }   

    // User change password 
    // public function updatePassword(Request $request, $id) {
    //     return $this->userservice->updatePassword($request, $id);
    // }

    public function updatePassword(Request $request){
        $user = auth()->user();
        $validatedData = $request->validate([
            'old_password' => 'required',
            'new_password' => 'required|min:6|confirmed',
        ]);

        // Check if the current password matches the user's actual password
        if (!Hash::check($request->old_password, $user->password)) {
            return response()->json(['message' => 'Current password is incorrect'], 400);
        }

        // Update the user's password
        $user->password = Hash::make($request->new_password);
        $user->save();

        return response()->json(['message' => 'Password changed successfully']);
    }

    // show details 
    public function ShowDetail($id){ 
        $user = User::with('userDetail')->find($id);
        return response()->json([
            'succes' => "true",
            'message' => 'show user details', 
            'data' => [  
                'id' => $user->id,
                'name' => $user->name,
                'email' => $user->email,
                'address' => $user->userDetail->address,
                // 'mobile_number' => $user->mobile_number
            ]
        ], 200);
    } 

    // update user details
    public function update(Request $request, $id) {

        $user = User::findOrFail($id);
        $user->name = $request->name;
        $user->mobile_number = $request->mobile_number;
        $user->update(); 

        $user = User::findOrFail($id);
        $userDetail = $user->userDetail;
        $userDetail->update($request->all());
        return response()->json([
            'succes' => "true",
            'message' => 'User details updated successfully',
            'user' => $user,
        ]);

    }

    // Get All Mentor
    public function getAllStudent(Request $request){
        return $this->userservice->getAllStudent($request);
    }
      
}
