<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Admin\CategoryService;
use App\Models\Category;

class CategoryController extends Controller {

    protected $CategoriesService; 
    
    public function __construct(
        CategoryService $categoryService
    ) {   
        $this->categoryService = $categoryService;
    }

    // Category index
    public function index(){
        $categories = Category::orderBy('id')->get();
        return view('admin.category.index', compact('categories')); 
    }

    // Category Create
    public function create(Request $request){
        return view('admin.category.create');
    }

    // Category Store
    public function store(Request $request){
        $this->categoryService->categoryStore($request);
        return redirect()->route('category.index')->with('success','Category created successfully.');
    }

    // Category Edit
    public function edit($id){
        $categories = Category::find($id);
        return view('admin.category.edit', compact('categories'));
    }

    // Category Update
    public function update($id, Request $request){
        $categories = Category::findOrFail($id);  
        $categories->name = $request->name; 
        $categories->save();
        return redirect()->route('category.index')->with('success','Category update successfully.');
    }
    
    // Category Delete
    public function destroy($id){
        $this->categoryService->deleteCategoryById($id);
        return redirect()->route('category.index')->with('success','Category Deleted successfully.');
    }

}
